<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package    local_mb2builder
 * @copyright  2018 - 2020 Mariusz Boloz (mb2moodle.com/)
 * @license   Commercial https://themeforest.net/licenses
 */

defined( 'MOODLE_INTERNAL' ) || die();

$mb2_settings = array(
	'id' => 'school',
	'title' => get_string( 'school', 'local_mb2builder' ),
	'items' => array(
		array(
			'name' => 'school-1',
			'thumb' => 'school-1',
			'tags' => 'school',
			'data' => '[{"type":"mb2pb_page","settings":{},"attr":[{"type":"mb2pb_section","settings":{"id":"section","size":"4","prbg":"0","scheme":"light","bgel1s":"500","bgel2s":"500","bgel1top":"200","bgel2top":"200","bgel1left":"0","bgel2left":"0","pt":"0","sectionhidden":"0","pb":"0","sectionaccess":"0","elname":"Section"},"attr":[{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgba(2, 32, 54, 0.65)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"dark","bgimage":"https://dummyimage.com/1900x1300/6f7076/333.jpg","heroimg":"0","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"120","pb":"70","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"col":"12","id":"column","pt":"0","pb":"30","mobcenter":"1","moborder":"0","align":"left","alignc":"none","height":"0","width":"665","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h2","size":"2.8","align":"left","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"20","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Pellentesque libero tortor","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"left","size":"n","sizerem":"1.2","showtitle":"0","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","upper":"0","title":"Title text","mt":"0","mb":"30","pv":"0","ph":"0","tmb":"30","width":"2000","rounded":"0","gradient":"0","button":"0","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"0","bborder":"0","btext":"Read more","bfwcls":"global","scheme":"light","content":"<p>Fusce vel dui. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Nunc nulla. Duis vel nibh at velit scelerisque suscipit. Praesent turpis.</p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"button","type":"primary","size":"xlg","link":"#","target":"0","fw":"0","fwcls":"medium","lspacing":"0","wspacing":"0","rounded":"0","upper":"0","ml":"0","mr":"0","mt":"0","mb":"20","border":"0","center":"0","text":"Start learning now","elname":"Button"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","heroimg":"0","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"70","pb":"10","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"5","pt":"0","pb":"30","mobcenter":"1","moborder":"0","align":"left","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h3","size":"2.2","align":"left","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"30","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Mauris sollicitudin fermentum","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"none","size":"n","sizerem":"1","showtitle":"0","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","upper":"0","title":"Title text","mt":"0","mb":"38","pv":"0","ph":"0","tmb":"30","width":"2000","rounded":"0","gradient":"0","button":"0","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"0","bborder":"0","btext":"Read more","bfwcls":"global","scheme":"light","content":"<p>Praesent ac sem eget est egestas volutpat. Pellentesque auctor neque nec urna. Suspendisse non nisl sit amet velit hendrerit rutrum. Nunc interdum lacus sit amet orci. Cras non dolor. Donec orci lectus, aliquam ut, faucibus non, euismod id, nulla. Phasellus consectetuer vestibulum elit. Nullam cursus lacinia erat. Pellentesque egestas, neque sit amet convallis pulvinar, justo nulla eleifend augue, ac auctor orci.</p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"button","type":"primary","size":"lg","link":"#","target":"0","fw":"0","fwcls":"medium","lspacing":"0","wspacing":"0","rounded":"0","upper":"0","ml":"0","mr":"0","mt":"0","mb":"20","border":"0","center":"0","text":"Learn more","elname":"Button"},"attr":[]}]},{"type":"mb2pb_col","settings":{"id":"column","col":"7","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"center","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"carousel","mt":"0","mb":"20","prestyle":"none","columns":"2","gutter":"normal","linkbtn":"0","title":"1","titlefs":"1.4","imgwidth":"800","mobcolumns":"0","desc":"1","sloop":"1","snav":"1","sdots":"1","autoplay":"1","pausetime":"5000","animtime":"450","elname":"Carousel"},"attr":[{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"1598105901687","image":"https://dummyimage.com/700x413/ccb593/333.jpg","title":"Vestibulum facilisis purus","desc":"Quisque libero metus, condimentum nec, tempor a, commodo mollis, magna. Praesent venenatis metus at tortor pulvinar varius.","link":"#","elname":"Carousel item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"1598105901688","image":"https://dummyimage.com/700x413/737c86/333.jpg","title":"Nullam vel sem","desc":"Curabitur at lacus ac velit ornare lobortis. Suspendisse nisl elit, rhoncus eget, elementum ac, condimentum eget, diam. ","link":"#","elname":"Carousel item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"1598105901689","image":"https://dummyimage.com/700x413/299d99/333.jpg","title":"Pellentesque habitant morbi","desc":"Nunc nec neque. Aenean vulputate eleifend tellus. Praesent ac sem eget est egestas volutpat. Vestibulum purus quam.","link":"#","elname":"Carousel item"},"attr":[]}]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgba(2, 32, 54, 0.85)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"dark","bgimage":"https://dummyimage.com/1900x1300/596f5f/333.jpg","heroimg":"0","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"70","pb":"10","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"1","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h3","size":"2.2","align":"center","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"30","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Pellentesque libero tortor","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"boxesicon","columns":"4","gutter":"normal","type":"1","color":"primary","rounded":"0","tfs":"1.4","wave":"0","height":"0","mt":"0","mb":"0","boxmb":"0","linkbtn":"0","desc":"1","elname":"Boxes - icon"},"attr":[{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-culture","title":"Etiam rhoncus","link_target":"0","content":"Pellentesque in ipsum id orci porta dapibus. Quisque velit nisi, pretium ut lacinia in, elementum id enim.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-cup","title":"Vivamus laoreet","link_target":"0","content":"Pellentesque in ipsum id orci porta dapibus. Quisque velit nisi, pretium ut lacinia in, elementum id enim.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-chat","title":"Etiam rhoncus","link_target":"0","content":"Pellentesque in ipsum id orci porta dapibus. Quisque velit nisi, pretium ut lacinia in, elementum id enim.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-news-paper","title":"Etiam rhoncus","link_target":"0","content":"Pellentesque in ipsum id orci porta dapibus. Quisque velit nisi, pretium ut lacinia in, elementum id enim.","elname":"Box icon"},"attr":[]}]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","heroimg":"0","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"70","pb":"10","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"left","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h2","size":"2.2","align":"center","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"30","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Pellentesque libero tortor","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"boxesimg","columns":"3","type":"3","mt":"0","mb":"0","desc":"0","rounded":"0","tfs":"1.4","linkbtn":"0","btntype":"primary","btnsize":"normal","btnfwcls":"global","btnrounded":"0","btnborder":"0","imgwidth":"800","gutter":"normal","elname":"Boxes - image"},"attr":[{"type":"mb2pb_subel","settings":{"id":"boxesimg_item","image":"https://dummyimage.com/700x413/7c8d88/333.jpg","link":"#","description":"Box description here...","link_target":"0","scheme":"dark","color":"rgba(2, 32, 54, 0.6)","text":"Vestibulum eu odio","elname":"Box image"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesimg_item","image":"https://dummyimage.com/700x413/7092bf/333.jpg","link":"#","description":"Box description here...","link_target":"0","scheme":"dark","color":"rgba(2, 32, 54, 0.6)","text":"Curabitur a felis","elname":"Box image"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesimg_item","image":"https://dummyimage.com/700x413/cc926f/333.jpg","link":"#","description":"Box description here...","link_target":"0","scheme":"dark","color":"rgba(2, 32, 54, 0.6)","text":"Donec vitae sapien","elname":"Box image"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesimg_item","image":"https://dummyimage.com/700x413/ef5354/333.jpg","link":"#","description":"Box description here...","link_target":"0","scheme":"dark","color":"rgba(2, 32, 54, 0.6)","text":"Curabitur a felis","elname":"Box image"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesimg_item","image":"https://dummyimage.com/700x413/b3b4b7/333.jpg","link":"#","description":"Box description here...","link_target":"0","scheme":"dark","color":"rgba(2, 32, 54, 0.6)","text":"Sed augue ipsum","elname":"Box image"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesimg_item","image":"https://dummyimage.com/700x413/a78f9d/333.jpg","link":"#","description":"Box description here...","link_target":"0","scheme":"dark","color":"rgba(2, 32, 54, 0.6)","text":"Vestibulum eu odio","elname":"Box image"},"attr":[]}]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgba(2, 32, 54, 0.85)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"dark","bgimage":"https://dummyimage.com/1900x1300/6b96bb/333.jpg","heroimg":"0","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"70","pb":"10","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"center","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h3","size":"2.2","align":"center","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"30","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Pellentesque libero tortor","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"animnum","columns":"4","mt":"0","mb":"30","pv":"32","gutter":"thin","icon":"0","center":"1","size_number":"4","size_icon":"5.6","size_title":"1","color_number":"rgba(255, 255, 255, 0.31)","nfwcls":"medium","tfwcls":"global","tlhcls":"global","color_bg":"rgba(255, 255, 255, 0.1)","subtitle":"0","nopadding":"0","aspeed":"10000","height":"0","elname":"Animated number"},"attr":[{"type":"mb2pb_subel","settings":{"id":"animnum_item","number":"750","icon":"fa fa-graduation-cap","title":"Aliquam erat volutpat","subtitle":"Phasellus leo dolor tempus non","elname":"Animated number item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"animnum_item","number":"25","icon":"fa fa-graduation-cap","title":"Nunc interdum lacus","subtitle":"Sed magna purus fermentum","elname":"Animated number item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"animnum_item","number":"150","icon":"fa fa-graduation-cap","title":"In enim justo","subtitle":"Donec quam felis ultricies nec","elname":"Animated number item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"animnum_item","number":"30","icon":"fa fa-graduation-cap","title":"Vivamus quis mi","subtitle":"Phasellus blandit leo ut odio","elname":"Animated number item"},"attr":[]}]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(233, 233, 233)","bgfixed":"0","colgutter":"s","prbg":"strip2","scheme":"light","heroimg":"0","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"0","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"0","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"carousel","mt":"0","mb":"0","prestyle":"none","columns":"5","gutter":"none","linkbtn":"0","title":"0","titlefs":"1.4","imgwidth":"150","mobcolumns":"1","desc":"0","sloop":"1","snav":"0","sdots":"0","autoplay":"1","pausetime":"5000","animtime":"450","elname":"Carousel"},"attr":[{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"1598703278122","image":"https://dummyimage.com/400x300/eeeeee/333.jpg","title":"Title text","desc":"Description text","elname":"Carousel item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"1598703364860","image":"https://dummyimage.com/400x300/eeeeee/333.jpg","title":"Title text","desc":"Description text","elname":"Carousel item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"1598703365603","image":"https://dummyimage.com/400x300/eeeeee/333.jpg","title":"Title text","desc":"Description text","elname":"Carousel item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"1598703366244","image":"https://dummyimage.com/400x300/eeeeee/333.jpg","title":"Title text","desc":"Description text","elname":"Carousel item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"1598703367009","image":"https://dummyimage.com/400x300/eeeeee/333.jpg","title":"Title text","desc":"Description text","elname":"Carousel item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"1598703367831","image":"https://dummyimage.com/400x300/eeeeee/333.jpg","title":"Title text","desc":"Description text","elname":"Carousel item"},"attr":[]}]}]}]}]}]}]'
		),
		array(
			'name' => 'school-language',
			'thumb' => 'school-language',
			'tags' => 'school',
			'data' => '[{"type":"mb2pb_page","settings":{},"attr":[{"type":"mb2pb_section","settings":{"id":"section","size":"4","margin":"","bgcolor":"","prbg":"0","scheme":"light","bgimage":"","bgel1":"","bgel2":"","bgel1s":"687","bgel2s":"372","bgel1top":"858","bgel2top":"814","bgel1left":"69","bgel2left":"-18","pt":"0","sectionhidden":"0","sectionlang":"","pb":"0","sectionaccess":"0","custom_class":"","template":"","elname":"Section"},"attr":[{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(242, 246, 250)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","bgimage":"","bordert":"0","borderb":"0","bordertcolor":"#dddddd","borderbcolor":"#dddddd","heroimg":"1","heroimgurl":"mb2sampledata:2022/12/demo-language-hero1","herov":"center","herow":"660","herohpos":"left","heroml":"49","heromt":"113","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0, 0, 0, 0.05)","bgvideo":"","rowhidden":"0","rowlang":"","pt":"200","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","custom_class":"id-mycustomid","template":"","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"1","wavetop":"0","wavewidth":"481","waveheight":"194","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradloc1":"0","gradloc2":"100","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"702","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h4","size":"2.95","align":"none","btext":"Discover the World with New Learning ","atext":"","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","nline":"0","mt":"0","mb":"30","width":"2000","color":"rgb(255, 183, 3)","acolor":"","bcolor":"","afwcls":"global","bfwcls":"global","custom_class":"","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"firstd|second word|third word","template":"","content":"Language School","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"listicon","style":"disc","icon":"ri-check-line","bgcolor":"","iconcolor":"rgb(58, 12, 163)","textcolor":"rgb(36, 32, 39)","border":"0","borderw":"2","bordercolor":"","horizontal":"0","align":"none","fwcls":"bold","isize":"2.95","space":"0","iconbg":"0","fs":"1","custom_class":"","mt":"0","mb":"30","template":"","elname":"List icon"},"attr":[{"type":"mb2pb_subel","settings":{"id":"listicon_item","icon":"","bgcolor":"","iconcolor":"","textcolor":"","bordercolor":"","link":"","link_target":"0","template":"","text":"Online laearning 24/7","elname":"List icon item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"listicon_item","icon":"","bgcolor":"","iconcolor":"","textcolor":"","bordercolor":"","link":"","link_target":"0","template":"","text":"Learn in a small groups","elname":"List icon item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"listicon_item","icon":"","bgcolor":"","iconcolor":"","textcolor":"","bordercolor":"","link":"","link_target":"0","template":"","text":"Beginner to advanced","elname":"List icon item"},"attr":[]}]},{"type":"mb2pb_el","settings":{"id":"select","custom_class":"","image":"1","layout":"h","label":"1","labeltext":"Choose one of 30 languages:","btntext":"Start learning today","btntype":"primary","size":"l","target":"0","btnrounded":"0","btnborder":"0","btnfwcls":"global","width":"2000","elcenter":"0","mt":"0","mb":"10","template":"","elname":"Select"},"attr":[{"type":"mb2pb_subel","settings":{"id":"select_item","link":"#","image":"https://dummyimage.com/80x80/eee/333.jpg","itemtext":"English","template":"","elname":"Select item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"select_item","link":"#","image":"https://dummyimage.com/80x80/eee/333.jpg","itemtext":"Spanish","template":"","elname":"Select item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"select_item","link":"#","image":"https://dummyimage.com/80x80/eee/333.jpg","itemtext":"English US","template":"","elname":"Select item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"select_item","link":"#","image":"https://dummyimage.com/80x80/eee/333.jpg","itemtext":"Norway","template":"","elname":"Select item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"select_item","link":"#","image":"https://dummyimage.com/80x80/eee/333.jpg","itemtext":"Greek","template":"","elname":"Select item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"select_item","link":"#","image":"https://dummyimage.com/80x80/eee/333.jpg","itemtext":"France","template":"","elname":"Select item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"select_item","link":"#","image":"https://dummyimage.com/80x80/eee/333.jpg","itemtext":"German","template":"","elname":"Select item"},"attr":[]}]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(242, 246, 250)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","bgimage":"","bordert":"0","borderb":"0","bordertcolor":"#dddddd","borderbcolor":"#dddddd","heroimg":"0","heroimgurl":"","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","bgvideo":"","rowhidden":"0","rowlang":"","pt":"60","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","custom_class":"","template":"","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"45","gradloc1":"0","gradloc2":"100","gradcolor1":"#37E2D5","gradcolor2":"#590696","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"0","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"boxesicon","columns":"4","gutter":"normal","type":"8","color":"secondary","ccolor":"rgb(58, 12, 163)","rounded":"0","tfs":"1","tfw":"bold","wave":"0","height":"0","mt":"0","mb":"0","boxmb":"0","linkbtn":"0","btntext":"","desc":"0","custom_class":"","template":"","elname":"Boxes - icon"},"attr":[{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"lni-world","type":"","title":"Learn more than 30  languages online","link":"","color":"","ccolor":"","link_target":"0","target":"","btntext":"","template":"","content":"Box content here.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"lni-book","type":"","title":"Over 3K verbs including full  conjugation and example","link":"","color":"","ccolor":"","link_target":"0","target":"","btntext":"","template":"","content":"Box content here.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"lni-comment-alt","type":"","title":"Focus on practical phrases  designed by native speakers","link":"","color":"","ccolor":"rgb(151, 47, 47)","link_target":"0","target":"","btntext":"","template":"","content":"Box content here.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"lni-gift","type":"","title":"Get free resources to help you enjoy learning quickly","link":"","color":"","ccolor":"","link_target":"0","target":"","btntext":"","template":"","content":"Box content here.","elname":"Box icon"},"attr":[]}]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","bgimage":"","bordert":"0","borderb":"0","bordertcolor":"#dddddd","borderbcolor":"#dddddd","heroimg":"0","heroimgurl":"","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","bgvideo":"","rowhidden":"0","rowlang":"","pt":"60","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","custom_class":"","template":"","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"45","gradloc1":"0","gradloc2":"100","gradcolor1":"#37E2D5","gradcolor2":"#590696","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h4","size":"2.2","align":"center","btext":"","atext":"","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","nline":"0","mt":"0","mb":"25","width":"2000","color":"","acolor":"","bcolor":"","afwcls":"global","bfwcls":"global","custom_class":"","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","template":"","content":"Language learning for all","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"center","size":"n","sizerem":"1","color":"","showtitle":"0","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","tcolor":"","upper":"0","title":"Title text","bgcolor":"","mt":"0","mb":"60","pv":"0","ph":"0","tmb":"30","width":"2000","rounded":"0","gradient":"0","button":"0","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"0","bborder":"0","btext":"Read more","bfwcls":"global","scheme":"light","custom_class":"","template":"","content":"<p>Vivamus suscipit tortor eget felis porttitor volutpat. Donec sollicitudin molestie malesuada.</p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"boxesimg","columns":"2","type":"6","mt":"0","mb":"0","custom_class":"","desc":"1","rounded":"1","tfs":"1.4","linkbtn":"2","btntype":"primary","btnsize":"normal","btnfwcls":"global","btnrounded":"0","btnborder":"0","btntext":"Start learning","imgwidth":"209","gutter":"normal","template":"","elname":"Boxes - image"},"attr":[{"type":"mb2pb_subel","settings":{"id":"boxesimg_item","image":"mb2sampledata:2022/12/demo-language-girl_1","link":"#","description":"Vivamus suscipit tortor eget felis porttitor volutpat. Donec sollicitudin molestie malesuada. Curabitur arcu erat, accumsan id imperdiet et, porttitor at sem. Donec sollicitudin molestie malesuada.","link_target":"0","scheme":"light","el_onmobile":"1","color":"rgb(242, 246, 250)","template":"","text":"For schools","elname":"Box image"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesimg_item","image":"mb2sampledata:2022/12/demo-language-girl_2","link":"#","description":"Vivamus suscipit tortor eget felis porttitor volutpat. Donec sollicitudin molestie malesuada. Curabitur arcu erat, accumsan id imperdiet et, porttitor at sem. Donec sollicitudin molestie malesuada.","link_target":"0","scheme":"light","el_onmobile":"1","color":"rgb(242, 246, 250)","template":"","text":"For individuals","elname":"Box image"},"attr":[]}]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","bgimage":"","bordert":"0","borderb":"0","bordertcolor":"#dddddd","borderbcolor":"#dddddd","heroimg":"0","heroimgurl":"","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","bgvideo":"","rowhidden":"0","rowlang":"","pt":"30","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","custom_class":"","template":"","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"45","gradloc1":"0","gradloc2":"100","gradcolor1":"#37E2D5","gradcolor2":"#590696","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h4","size":"2.2","align":"center","btext":"","atext":"","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","nline":"0","mt":"0","mb":"25","width":"2000","color":"","acolor":"","bcolor":"","afwcls":"global","bfwcls":"global","custom_class":"","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","template":"","content":"Languages by level","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"center","size":"n","sizerem":"1","color":"","showtitle":"0","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","tcolor":"","upper":"0","title":"Title text","bgcolor":"","mt":"0","mb":"60","pv":"0","ph":"0","tmb":"30","width":"2000","rounded":"0","gradient":"0","button":"0","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"0","bborder":"0","btext":"Read more","bfwcls":"global","scheme":"light","custom_class":"","template":"","content":"<p>Vivamus suscipit tortor eget felis porttitor volutpat. Donec sollicitudin molestie malesuada.</p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"process","columns":"3","gutter":"normal","type":"1","rounded":"0","tfs":"1.4","tfw":"global","labelpos":"left","wave":"0","height":"0","mt":"0","mb":"0","boxmb":"15","desc":"1","icon":"pe-7s-sun","isicon":"0","custom_class":"","template":"","elname":"Process"},"attr":[{"type":"mb2pb_subel","settings":{"id":"process_item","icon":"","title":"Languages for beginners","label":"A","link":"","color":"","bgcolor":"rgb(27, 204, 186)","link_target":"0","template":"","content":"Curabitur arcu erat, accumsan id imperdiet et, porttitor at sem. Curabitur non nulla sit amet nisl tempus convallis quis ac lectus. Donec sollicitudin.","elname":"Process item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"process_item","icon":"fa fa-lightbulb-o","title":"Languages for intermediate","label":"B","link":"","color":"","bgcolor":"rgb(247, 37, 133)","link_target":"0","template":"","content":"Curabitur arcu erat, accumsan id imperdiet et, porttitor at sem. Curabitur non nulla sit amet nisl tempus convallis quis ac lectus. Donec sollicitudin.","elname":"Process item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"process_item","icon":"","title":"Languages for advanced","label":"C","link":"","color":"","bgcolor":"rgb(255, 183, 3)","link_target":"0","template":"","content":"Curabitur arcu erat, accumsan id imperdiet et, porttitor at sem. Curabitur non nulla sit amet nisl tempus convallis quis ac lectus. Donec sollicitudin.","elname":"Process item"},"attr":[]}]},{"type":"mb2pb_el","settings":{"id":"boxescontent","columns":"1","gutter":"normal","type":"1","rounded":"1","tfs":"1.4","tfw":"global","wave":"0","height":"0","mt":"0","mb":"0","boxmb":"0","padding":"m","shadow":"0","custom_class":"","btnhor":"1","cwidth":"2000","linkbtn":"2","btntype":"primary","btnsize":"normal","btnfwcls":"global","btnrounded":"0","btnborder":"0","btntext":"Test my language","template":"","elname":"Boxes - content"},"attr":[{"type":"mb2pb_subel","settings":{"id":"boxescontent_item","icon":"","title":"Test your language level","link":"#","bgimage":"","scheme":"light","color":"","bgcolor":"rgb(242, 246, 250)","link_target":"1","template":"","content":"Donec rutrum congue leo eget malesuada. Sed porttitor lectus nibh.","elname":"Box content"},"attr":[]}]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(242, 246, 250)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","bgimage":"","bordert":"0","borderb":"0","bordertcolor":"#dddddd","borderbcolor":"#dddddd","heroimg":"0","heroimgurl":"","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","bgvideo":"","rowhidden":"0","rowlang":"","pt":"60","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","custom_class":"","template":"","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"45","gradloc1":"0","gradloc2":"100","gradcolor1":"#37E2D5","gradcolor2":"#590696","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"0","moborder":"2","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"image","align":"none","center":"1","width":"450","alt":"","mt":"0","mb":"30","caption":"0","captiontext":"Caption text here","link":"","link_target":"0","custom_class":"","template":"","text":"mb2sampledata:2022/12/demo-language-row1","elname":"Image"},"attr":[]}]},{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"1","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h4","size":"2.2","align":"none","btext":"","atext":"","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","nline":"0","mt":"0","mb":"25","width":"2000","color":"","acolor":"","bcolor":"","afwcls":"global","bfwcls":"global","custom_class":"","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","template":"","content":"Our language exams","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"none","size":"n","sizerem":"1","color":"","showtitle":"0","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","tcolor":"","upper":"0","title":"Title text","bgcolor":"","mt":"0","mb":"35","pv":"0","ph":"0","tmb":"30","width":"2000","rounded":"0","gradient":"0","button":"0","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"0","bborder":"0","btext":"Read more","bfwcls":"global","scheme":"light","custom_class":"","template":"","content":"<p>Vivamus suscipit tortor eget felis porttitor volutpat. Donec sollicitudin molestie malesuada. Curabitur arcu erat, accumsan id imperdiet et.</p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"boxescontent","columns":"2","gutter":"normal","type":"2","rounded":"1","tfs":"1.4","tfw":"global","wave":"0","height":"0","mt":"0","mb":"0","boxmb":"0","padding":"m","shadow":"1","custom_class":"","btnhor":"0","cwidth":"2000","linkbtn":"0","btntype":"primary","btnsize":"normal","btnfwcls":"global","btnrounded":"0","btnborder":"0","btntext":"","template":"","elname":"Boxes - content"},"attr":[{"type":"mb2pb_subel","settings":{"id":"boxescontent_item","icon":"","title":"TELC","link":"","bgimage":"","scheme":"light","color":"","bgcolor":"rgb(255, 255, 255)","link_target":"0","template":"","content":"Curabitur aliquet quam id dui posuere blandit.","elname":"Box content"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxescontent_item","icon":"","title":"TOEIC","link":"","bgimage":"","scheme":"light","color":"rgb(58, 12, 163)","bgcolor":"rgb(255, 255, 255)","link_target":"0","template":"","content":"Curabitur aliquet quam id dui posuere blandit.","elname":"Box content"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxescontent_item","icon":"","title":"IELTS","link":"","bgimage":"","scheme":"light","color":"rgb(27, 204, 186)","bgcolor":"rgb(255, 255, 255)","link_target":"0","template":"","content":"Curabitur aliquet quam id dui posuere blandit.","elname":"Box content"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxescontent_item","icon":"","title":"TOEFL","link":"","bgimage":"","scheme":"light","color":"rgb(247, 37, 133)","bgcolor":"rgb(255, 255, 255)","link_target":"0","template":"","content":"Curabitur aliquet quam id dui posuere blandit.","elname":"Box content"},"attr":[]}]},{"type":"mb2pb_el","settings":{"id":"button","type":"link","size":"normal","link":"#","target":"0","isicon":"0","icon":"fa fa-power-off","fw":"0","fwcls":"medium","lspacing":"0","wspacing":"0","rounded":"0","upper":"0","custom_class":"","ml":"0","mr":"0","mt":"0","mb":"15","border":"0","center":"0","color":"rgb(58, 12, 163)","bgcolor":"","borcolor":"","bghcolor":"","hcolor":"rgb(58, 12, 163)","borhcolor":"","template":"","text":"Language certificate preparation courses","elname":"Button"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","bgimage":"","bordert":"0","borderb":"0","bordertcolor":"#dddddd","borderbcolor":"#dddddd","heroimg":"0","heroimgurl":"","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","bgvideo":"","rowhidden":"0","rowlang":"","pt":"60","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","custom_class":"","template":"","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"45","gradloc1":"0","gradloc2":"100","gradcolor1":"#37E2D5","gradcolor2":"#590696","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"10","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h4","size":"2.2","align":"center","btext":"","atext":"","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","nline":"0","mt":"0","mb":"40","width":"2000","color":"","acolor":"","bcolor":"","afwcls":"global","bfwcls":"global","custom_class":"","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","template":"","content":"Hear it from our students","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"testimonials","mt":"0","mb":"0","width":"","custom_class":"","clayout":"2","columns":"4","gutter":"normal","isimage":"1","iscompany":"1","isjob":"1","mobcolumns":"1","sloop":"0","snav":"0","sdots":"1","autoplay":"0","pausetime":"5000","animtime":"450","template":"","elname":"Testimonials"},"attr":[{"type":"mb2pb_subel","settings":{"id":"testimonials_item","pbid":"4309","image":"https://dummyimage.com/100x100/eeeeee/333333.jpg","name":"Full Name","job":"Moodle Dev","rating":"5","companyname":"Company name","text":"Istam voluptatem, inquit, Epicurus ignorat. Rhetorice igitur, inquam, nos mavis quam dialectice disputare. Non est igitur summum malum dolor.","elname":"Testimonials item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"testimonials_item","pbid":"4310","image":"https://dummyimage.com/100x100/eeeeee/333333.jpg","name":"Full Name","job":"Moodle Dev","rating":"5","companyname":"Company name","text":"Istam voluptatem, inquit, Epicurus ignorat. Rhetorice igitur, inquam, nos mavis quam dialectice disputare. Non est igitur summum malum dolor.","elname":"Testimonials item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"testimonials_item","pbid":"4311","image":"https://dummyimage.com/100x100/eeeeee/333333.jpg","name":"Full Name","job":"Moodle Dev","rating":"5","companyname":"Company name","text":"Istam voluptatem, inquit, Epicurus ignorat. Rhetorice igitur, inquam, nos mavis quam dialectice disputare. Non est igitur summum malum dolor.","elname":"Testimonials item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"testimonials_item","pbid":"4312","image":"https://dummyimage.com/100x100/eeeeee/333333.jpg","name":"Full Name","job":"Moodle Dev","rating":"5","companyname":"Company name","text":"Istam voluptatem, inquit, Epicurus ignorat. Rhetorice igitur, inquam, nos mavis quam dialectice disputare. Non est igitur summum malum dolor.","elname":"Testimonials item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"testimonials_item","pbid":"4313","image":"https://dummyimage.com/100x100/eeeeee/333333.jpg","name":"Full Name","job":"Moodle Dev","rating":"5","companyname":"Company name","text":"Istam voluptatem, inquit, Epicurus ignorat. Rhetorice igitur, inquam, nos mavis quam dialectice disputare. Non est igitur summum malum dolor.","elname":"Testimonials item"},"attr":[]}]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","bgimage":"","bordert":"0","borderb":"0","bordertcolor":"#dddddd","borderbcolor":"#dddddd","heroimg":"0","heroimgurl":"","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","bgvideo":"","rowhidden":"0","rowlang":"","pt":"0","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","custom_class":"","template":"","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"45","gradloc1":"0","gradloc2":"100","gradcolor1":"#37E2D5","gradcolor2":"#590696","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"center","height":"0","width":"909","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"carousel","mt":"0","mb":"30","width":"","custom_class":"","prestyle":"none","columns":"4","gutter":"normal","linkbtn":"0","title":"0","titlefs":"1.4","imgwidth":"182","mobcolumns":"1","desc":"0","btntext":"","sloop":"1","snav":"0","sdots":"0","autoplay":"1","pausetime":"5000","animtime":"450","template":"","elname":"Carousel"},"attr":[{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"8569","image":"https://dummyimage.com/345x120/eeeeee/333.jpg","title":"Title text","desc":"Description text","color":"","link":"","link_target":"","elname":"Carousel item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"8570","image":"https://dummyimage.com/345x120/eeeeee/333.jpg","title":"Title text","desc":"Description text","color":"","link":"","link_target":"","elname":"Carousel item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"8571","image":"https://dummyimage.com/345x120/eeeeee/333.jpg","title":"Title text","desc":"Description text","color":"","link":"","link_target":"","elname":"Carousel item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"8572","image":"https://dummyimage.com/345x120/eeeeee/333.jpg","title":"Title text","desc":"Description text","color":"","link":"","link_target":"","elname":"Carousel item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"8573","image":"https://dummyimage.com/345x120/eeeeee/333.jpg","title":"Title text","desc":"Description text","color":"","link":"","link_target":"","elname":"Carousel item"},"attr":[]}]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(242, 246, 250)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","bgimage":"","bordert":"0","borderb":"0","bordertcolor":"#dddddd","borderbcolor":"#dddddd","heroimg":"1","heroimgurl":"mb2sampledata:2022/12/demo_language_shape_bg1","herov":"center","herow":"1700","herohpos":"left","heroml":"-19","heromt":"-106","heroonsmall":"0","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","bgvideo":"","rowhidden":"0","rowlang":"","pt":"60","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","custom_class":"","template":"","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"45","gradloc1":"0","gradloc2":"100","gradcolor1":"#37E2D5","gradcolor2":"#590696","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"center","height":"0","width":"664","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h4","size":"2.2","align":"center","btext":"","atext":"","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","nline":"0","mt":"0","mb":"60","width":"2000","color":"","acolor":"","bcolor":"","afwcls":"global","bfwcls":"global","custom_class":"","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","template":"","content":"Frequently asked questions","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"accordion","show_all":"0","builder":"1","type":"default","size":"m","padding":"1","rounded":"1","custom_class":"","tfs":"1","tfw":"bold","tcolor":"rgb(36, 32, 39)","thcolor":"rgb(36, 32, 39)","hbgcolor":"rgb(255, 255, 255)","hbghcolor":"rgb(208, 223, 238)","cbgcolor":"rgb(227, 236, 245)","iconcolor":"rgb(58, 12, 163)","iconhcolor":"rgb(58, 12, 163)","scheme":"light","isicon":"1","icon":"ri-questionnaire-fill","accordion_active":"1","mt":"0","mb":"30","parent":"1","template":"","elname":"Accordion"},"attr":[{"type":"mb2pb_subel","settings":{"id":"accordion_item","title":"Accordion title here","icon":"","template":"","text":"Nulla quis lorem ut libero malesuada feugiat. Cras ultricies ligula sed magna dictum porta. Quisque velit nisi, pretium ut lacinia in, elementum id enim. Vivamus magna justo, lacinia eget consectetur sed, convallis at tellus. Curabitur non nulla sit amet nisl tempus convallis quis ac lectus. Nulla porttitor accumsan tincidunt.","elname":"Accordion item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"accordion_item","title":"Accordion title here","icon":"","template":"","text":"Nulla quis lorem ut libero malesuada feugiat. Cras ultricies ligula sed magna dictum porta. Quisque velit nisi, pretium ut lacinia in, elementum id enim. Vivamus magna justo, lacinia eget consectetur sed, convallis at tellus. Curabitur non nulla sit amet nisl tempus convallis quis ac lectus. Nulla porttitor accumsan tincidunt.","elname":"Accordion item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"accordion_item","title":"Accordion title here","icon":"","template":"","text":"Nulla quis lorem ut libero malesuada feugiat. Cras ultricies ligula sed magna dictum porta. Quisque velit nisi, pretium ut lacinia in, elementum id enim. Vivamus magna justo, lacinia eget consectetur sed, convallis at tellus. Curabitur non nulla sit amet nisl tempus convallis quis ac lectus. Nulla porttitor accumsan tincidunt.","elname":"Accordion item"},"attr":[]}]},{"type":"mb2pb_el","settings":{"id":"button","type":"link","size":"normal","link":"#","target":"0","isicon":"0","icon":"fa fa-play-circle-o","fw":"0","fwcls":"global","lspacing":"0","wspacing":"0","rounded":"0","upper":"0","custom_class":"","ml":"0","mr":"0","mt":"0","mb":"15","border":"0","center":"0","color":"rgb(58, 12, 163)","bgcolor":"","borcolor":"","bghcolor":"","hcolor":"rgb(58, 12, 163)","borhcolor":"","template":"","text":"View all frequently asked questions","elname":"Button"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(255, 183, 3)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","bgimage":"","bordert":"0","borderb":"0","bordertcolor":"#dddddd","borderbcolor":"#dddddd","heroimg":"0","heroimgurl":"","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","bgvideo":"","rowhidden":"0","rowlang":"","pt":"60","pb":"0","fw":"0","va":"1","parallax":"0","rowaccess":"0","custom_class":"","template":"","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"45","gradloc1":"0","gradloc2":"100","gradcolor1":"#37E2D5","gradcolor2":"#590696","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"1","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h4","size":"1.33","align":"center","btext":"","atext":"","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","nline":"0","mt":"0","mb":"30","width":"2000","color":"","acolor":"","bcolor":"","afwcls":"global","bfwcls":"global","custom_class":"","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","template":"","content":"Book your first language lesson today:","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"select","custom_class":"","image":"1","layout":"h","label":"0","labeltext":"Choose one of 30 languages:","btntext":"Start learning today","btntype":"primary","size":"l","target":"0","btnrounded":"0","btnborder":"0","btnfwcls":"global","width":"2000","elcenter":"1","mt":"0","mb":"30","template":"","elname":"Select"},"attr":[{"type":"mb2pb_subel","settings":{"id":"select_item","link":"#","image":"https://dummyimage.com/80x80/eee/333.jpg","itemtext":"English","template":"","elname":"Select item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"select_item","link":"#","image":"https://dummyimage.com/80x80/eee/333.jpg","itemtext":"Spanish","template":"","elname":"Select item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"select_item","link":"#","image":"https://dummyimage.com/80x80/eee/333.jpg","itemtext":"English US","template":"","elname":"Select item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"select_item","link":"#","image":"https://dummyimage.com/80x80/eee/333.jpg","itemtext":"Norway","template":"","elname":"Select item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"select_item","link":"#","image":"https://dummyimage.com/80x80/eee/333.jpg","itemtext":"Greek","template":"","elname":"Select item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"select_item","link":"#","image":"https://dummyimage.com/80x80/eee/333.jpg","itemtext":"France","template":"","elname":"Select item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"select_item","link":"#","image":"https://dummyimage.com/80x80/eee/333.jpg","itemtext":"German","template":"","elname":"Select item"},"attr":[]}]}]}]}]}]}]'
		),
		array(
			'name' => 'school-2',
			'thumb' => 'school-2',
			'tags' => 'school',
			'data' => '[{"type":"mb2pb_page","settings":{},"attr":[{"type":"mb2pb_section","settings":{"id":"section","size":"4","prbg":"0","scheme":"light","bgel1s":"500","bgel2s":"500","bgel1top":"200","bgel2top":"200","bgel1left":"0","bgel2left":"0","pt":"0","sectionhidden":"0","pb":"0","sectionaccess":"0","elname":"Section"},"attr":[{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(241, 247, 231)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","heroimg":"1","heroimgurl":"https://dummyimage.com/1900x1343/f1f0ef/333.jpg","herov":"bottom","herow":"941","herohpos":"left","heroml":"47","heromt":"0","heroonsmall":"1","herogradl":"1","herogradr":"1","bgtext":"1","bgtextmob":"0","bgtexttext":"New Learning","btsize":"445","btfweight":"600","btlh":"0.75","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0, 0, 0, 0.04)","rowhidden":"0","pt":"190","pb":"140","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"1","wavetop":"0","wavewidth":"100","waveheight":"74","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"1","moborder":"0","align":"left","alignc":"none","height":"0","width":"767","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h2","size":"3.3","align":"left","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"30","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Study online with New Learning","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"left","size":"n","sizerem":"1.2","showtitle":"0","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","upper":"0","title":"Title text","mt":"0","mb":"40","pv":"0","ph":"0","tmb":"40","width":"2000","rounded":"0","gradient":"0","button":"0","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"0","bborder":"0","btext":"Read more","scheme":"light","content":"<p>Taking your online and distance learning to new heights. Accounting, graphic design, business management and more...</p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"button","type":"primary","size":"xlg","link":"#","target":"0","fw":"0","fwcls":"medium","lspacing":"0","wspacing":"0","rounded":"0","upper":"0","ml":"0","mr":"20","mt":"0","mb":"20","border":"0","center":"0","text":"Discover more","elname":"Button"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"button","type":"primary","size":"xlg","link":"#","target":"0","fw":"0","fwcls":"medium","lspacing":"0","wspacing":"0","rounded":"0","upper":"0","ml":"0","mr":"0","mt":"0","mb":"20","border":"1","center":"0","text":"Start learning now","elname":"Button"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","heroimg":"0","herov":"center","herow":"750","herohpos":"left","heroml":"50","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.1)","rowhidden":"0","pt":"60","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"3","wavecolor":"rgb(244, 252, 217)","wavepos":"0","wavefliph":"1","wavetop":"0","wavewidth":"881","waveheight":"370","waveover":"0","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"boxesimg","columns":"3","type":"4","mt":"0","mb":"0","desc":"1","rounded":"1","tfs":"1.6","linkbtn":"1","btntype":"primary","btnsize":"normal","btnrounded":"0","btnborder":"0","btntext":"0","imgwidth":"770","gutter":"normal","elname":"Boxes - image"},"attr":[{"type":"mb2pb_subel","settings":{"id":"boxesimg_item","image":"https://dummyimage.com/700x413/a9de6d/333.jpg","link":"#","description":"Sin aliud quid voles, postea. Ita multa dicunt, quae vix intellegam. Quis istum dolorem timet? Falli igitur possumus pius est.","link_target":"0","scheme":"light","color":"rgb(182, 235, 122)","text":"Advanced learning tools","elname":"Box image"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesimg_item","image":"https://dummyimage.com/700x413/51d9de/333.jpg","link":"#","description":"Sin aliud quid voles, postea. Ita multa dicunt, quae vix intellegam. Quis istum dolorem timet? Falli igitur possumus pius est.","link_target":"0","scheme":"light","color":"rgb(94, 230, 235)","text":"Personalized learning","elname":"Box image"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesimg_item","image":"https://dummyimage.com/700x413/f2eb5d/333.jpg","link":"#","description":"Sin aliud quid voles, postea. Ita multa dicunt, quae vix intellegam. Quis istum dolorem timet? Falli igitur possumus pius est.","link_target":"0","scheme":"light","color":"rgb(255, 247, 106)","text":"Best teachers","elname":"Box image"},"attr":[]}]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(244, 252, 217)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","heroimg":"0","herov":"center","herow":"750","herohpos":"left","heroml":"50","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.1)","rowhidden":"0","pt":"0","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"0","moborder":"2","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h3","size":"2.4","align":"none","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"30","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Our achivements","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"none","size":"n","sizerem":"1","showtitle":"0","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","upper":"0","title":"Title text","mt":"0","mb":"30","pv":"0","ph":"0","tmb":"30","width":"2000","rounded":"0","gradient":"0","button":"0","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"0","bborder":"0","btext":"Read more","scheme":"light","content":"<p>Nam prius a se poterit quisque discedere quam appetitum earum rerum, quae sibi conducant, amittere. Unam praeclarissimam omnium maximeque laudandam, penitus viderent, quonam gaudio complerentur, cum tantopere eius.</p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"animnum","columns":"2","mt":"0","mb":"0","pv":"5","gutter":"normal","icon":"0","center":"0","size_number":"2.6","size_icon":"3.15","size_title":"1","color_number":"rgb(51, 51, 51)","nfwcls":"bold","tfwcls":"global","tlhcls":"global","color_bg":"rgba(255, 255, 255, 0)","subtitle":"0","nopadding":"1","aspeed":"10000","height":"0","elname":"Animated number"},"attr":[{"type":"mb2pb_subel","settings":{"id":"animnum_item","number":"8500","icon":"fa fa-graduation-cap","title":"students enrolled in our courses around the world.","subtitle":"Subtitle here","elname":"Animated number item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"animnum_item","number":"1200","icon":"fa fa-graduation-cap","title":"high quality course divided into 50 categories. ","subtitle":"Subtitle here","elname":"Animated number item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"animnum_item","number":"96","icon":"fa fa-graduation-cap","title":"% of our customers rated 5-star our courses over 3 years.","subtitle":"Subtitle here","elname":"Animated number item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"animnum_item","number":"75","icon":"fa fa-graduation-cap","title":"% learners leads to better jobs with our courses.","subtitle":"Subtitle here","elname":"Animated number item"},"attr":[]}]}]},{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"0","moborder":"1","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"image","align":"none","center":"1","width":"1000","mt":"0","mb":"30","caption":"0","captiontext":"Caption text here","link_target":"0","text":"https://dummyimage.com/1000x693/e2e37f/333.jpg","elname":"Image"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","heroimg":"0","herov":"center","herow":"750","herohpos":"left","heroml":"50","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.1)","rowhidden":"0","pt":"60","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h3","size":"2.4","align":"center","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"30","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"What does the future hold for you?","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"center","size":"n","sizerem":"1","showtitle":"0","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","upper":"0","title":"Title text","mt":"0","mb":"40","pv":"0","ph":"0","tmb":"30","width":"729","rounded":"0","gradient":"0","button":"0","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"0","bborder":"0","btext":"Read more","scheme":"light","content":"<p>New Learning has over 1 200 courses available. All of courses have been designed by subject matter experts to give you an interactive and enjoyable learning experience.</p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"boxesicon","columns":"4","gutter":"normal","type":"7","color":"primary","ccolor":"rgb(51, 51, 51)","rounded":"1","tfs":"1","wave":"0","height":"80","mt":"0","mb":"0","boxmb":"0","linkbtn":"0","desc":"0","elname":"Boxes - icon"},"attr":[{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-cash","title":"Business and economy","link":"#","link_target":"0","content":"Box content here.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-culture","title":"Architecture","link":"#","link_target":"0","content":"Box content here.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-graph1","title":"Data analysis","link":"#","link_target":"0","content":"Box content here.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-global","title":"Languages","link":"#","link_target":"0","content":"Box content here.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-pen","title":"Graphic design","link":"#","link_target":"0","content":"Box content here.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-cart","title":"Marketing","link":"#","link_target":"0","content":"Box content here.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-server","title":"IT and software","link":"#","link_target":"0","content":"Box content here.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-music","title":"Music","link":"#","link_target":"0","content":"Box content here.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-camera","title":"Photography","link":"#","link_target":"0","content":"Box content here.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-calculator","title":"Accounting","link":"#","link_target":"0","content":"Box content here.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-share","title":"Social media","link":"#","link_target":"0","content":"Box content here.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-leaf","title":"Ecology","link":"#","link_target":"0","content":"Box content here.","elname":"Box icon"},"attr":[]}]},{"type":"mb2pb_el","settings":{"id":"button","type":"primary","size":"lg","link":"#","target":"0","fw":"0","fwcls":"medium","lspacing":"0","wspacing":"0","rounded":"0","upper":"0","ml":"0","mr":"0","mt":"0","mb":"40","border":"0","center":"1","text":"View all categories","elname":"Button"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"line","color":"custom","custom_color":"rgba(0, 0, 0, 0.068)","size":"4","double":"0","style":"solid","mt":"30","mb":"30","elname":"Line"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"heading","tag":"h3","size":"2.4","align":"center","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"30","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Featured courses","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"courses","limit":"8","excourses":"0","excats":"0","extags":"0","carousel":"1","columns":"4","sloop":"0","snav":"1","sdots":"0","autoplay":"0","pausetime":"5000","animtime":"450","desclimit":"25","titlelimit":"6","gutter":"normal","linkbtn":"0","prestyle":"none","mt":"0","mb":"30","coursestudentscount":"1","coursinstructor":"1","courseprice":"1","elname":"Courses"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(244, 252, 217)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","heroimg":"1","heroimgurl":"https://dummyimage.com/1600x928/e2e37f/333.jpg","herov":"center","herow":"761","herohpos":"right","heroml":"54","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.1)","rowhidden":"0","pt":"60","pb":"0","fw":"0","va":"1","parallax":"1","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"20","mobcenter":"0","moborder":"0","align":"none","alignc":"right","height":"0","width":"592","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h3","size":"2.4","align":"none","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"30","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"We are New Learning and we are \ndifferent","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"none","size":"n","sizerem":"1","showtitle":"0","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","upper":"0","title":"Title text","mt":"0","mb":"30","pv":"0","ph":"0","tmb":"30","width":"2000","rounded":"0","gradient":"0","button":"0","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"0","bborder":"0","btext":"Read more","scheme":"light","content":"<p>Publi, o gurges, Galloni! es homo miser, inquit. Huius ego nunc auctoritatem sequens idem faciam. Sine ea igitur iucunde negat posse se vivere? Quis enim est, qui non videat haec esse in natura rerum tria? Sed haec ab Antiocho, familiari nostro, dicuntur multo melius et fortius, quam a Stasea dicebantur. Num igitur dubium est, quin.</p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"listicon","style":"disc","icon":"pe-7s-check","border":"0","borderw":"2","horizontal":"0","fweight":"400","iconbg":"0","mt":"0","mb":"30","elname":"List icon"},"attr":[{"type":"mb2pb_subel","settings":{"id":"listicon_item","link_target":"0","text":"Est enim tanti philosophi tamque nobilis audacter sua decreta defendere.","elname":"List icon item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"listicon_item","link_target":"0","text":"Rem unam praeclarissimam laudandam.","elname":"List icon item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"listicon_item","link_target":"0","text":"Is cum arderet podagrae doloribus visitassetque homine.","elname":"List icon item"},"attr":[]}]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","heroimg":"0","herov":"center","herow":"750","herohpos":"left","heroml":"50","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.1)","rowhidden":"0","pt":"60","pb":"0","fw":"0","va":"1","parallax":"1","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"center","height":"0","width":"856","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h3","size":"2.4","align":"center","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"30","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Frequently Asked Questions","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"accordion","show_all":"0","builder":"1","type":"minimal","size":"l","tfs":"1.6","isicon":"0","icon":"fa fa-trophy","accordion_active":"1","mt":"0","mb":"30","parent":"1","elname":"Accordion"},"attr":[{"type":"mb2pb_subel","settings":{"id":"accordion_item","title":"How do I locate a program that is right for me?","text":"Nam cum Academicis incerta luctatio est, qui nihil affirmant et quasi desperata cognitione certi id sequi volunt, quodcumque veri simile videatur. An potest, inquit ille, quicquam esse suavius quam nihil dolere.","elname":"Accordion item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"accordion_item","title":"When should I apply?","text":"Quod est, ut dixi, habere ea, quae secundum naturam sint, vel omnia vel plurima et maxima. Inquit, an parum disserui non verbis Stoicos a Peripateticis, sed universa re et tota sententia dissidere.","elname":"Accordion item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"accordion_item","title":"How do I access my student account?","text":"Teneo, inquit, finem illi videri nihil dolere. Cuius similitudine perspecta in formarum specie ac dignitate transitum est ad honestatem dictorum atque factorum.","elname":"Accordion item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"accordion_item","title":"How do I decide which courses to take?","text":" Huic ego, si negaret quicquam interesse ad beate vivendum quali uteretur victu, concederem, laudarem etiam; Quod ea non occurrentia fingunt, vincunt Aristonem.","elname":"Accordion item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"accordion_item","title":"Where should I direct technology questions?","text":"Polemoni et iam ante Aristoteli ea prima visa sunt, quae paulo ante dixi. Negat esse eam, inquit, propter se expetendam.","elname":"Accordion item"},"attr":[]}]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(94, 230, 235)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","heroimg":"1","heroimgurl":"https://dummyimage.com/1600x1600/45cdd2/333.jpg","herov":"center","herow":"455","herohpos":"left","heroml":"75","heromt":"181","heroonsmall":"0","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.1)","rowhidden":"0","pt":"140","pb":"80","fw":"0","va":"1","parallax":"1","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"center","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h3","size":"3.3","align":"none","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"0","width":"1036","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Decisions are hard.","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"heading","tag":"h3","size":"3.3","align":"none","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"40","width":"1036","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Choosing New Learning is easy.","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"button","type":"success","size":"lg","link":"#","target":"0","fw":"0","fwcls":"medium","lspacing":"0","wspacing":"0","rounded":"0","upper":"0","ml":"0","mr":"0","mt":"0","mb":"30","border":"0","center":"0","text":"Buy New Learning for $99","elname":"Button"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgfixed":"0","colgutter":"xl","prbg":"0","scheme":"light","heroimg":"0","herov":"center","herow":"750","herohpos":"left","heroml":"50","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.1)","rowhidden":"0","pt":"30","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h4","size":"1","align":"center","fwcls":"bold","lhcls":"global","lspacing":"0","wspacing":"0","upper":"1","mt":"0","mb":"15","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Proudly collaborate with","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"carousel","mt":"0","mb":"0","prestyle":"grayscale","columns":"5","gutter":"none","linkbtn":"0","title":"0","titlefs":"1.4","imgwidth":"102","mobcolumns":"1","desc":"0","sloop":"0","snav":"0","sdots":"0","autoplay":"1","pausetime":"5000","animtime":"450","elname":"Carousel"},"attr":[{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"1614078145905","image":"https://dummyimage.com/400x300/eeeeee/333.jpg","title":"Title text","desc":"Description text","elname":"Carousel item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"1614078145906","image":"https://dummyimage.com/400x300/eeeeee/333.jpg","title":"Title text","desc":"Description text","elname":"Carousel item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"1614078145907","image":"https://dummyimage.com/400x300/eeeeee/333.jpg","title":"Title text","desc":"Description text","elname":"Carousel item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"1614078145908","image":"https://dummyimage.com/400x300/eeeeee/333.jpg","title":"Title text","desc":"Description text","elname":"Carousel item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"1614078145909","image":"https://dummyimage.com/400x300/eeeeee/333.jpg","title":"Title text","desc":"Description text","elname":"Carousel item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"1614079449041","image":"https://dummyimage.com/400x300/eeeeee/333.jpg","title":"Title text","desc":"Description text","elname":"Carousel item"},"attr":[]}]}]}]}]}]}]'
		),
		array(
			'name' => 'school-3',
			'thumb' => 'school-3',
			'tags' => 'school',
			'data' => '[{"type":"mb2pb_page","settings":{},"attr":[{"type":"mb2pb_section","settings":{"id":"section","size":"4","prbg":"0","scheme":"light","bgel1s":"500","bgel2s":"500","bgel1top":"200","bgel2top":"200","bgel1left":"0","bgel2left":"0","pt":"0","sectionhidden":"0","pb":"0","sectionaccess":"0","elname":"Section"},"attr":[{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgba(15, 15, 15, 0.7)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"dark","bgimage":"https://dummyimage.com/1900x800/566371/333.jpg","heroimg":"0","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"200","pb":"200","fw":"0","va":"0","parallax":"1","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"1","moborder":"0","align":"none","alignc":"none","height":"0","width":"777","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h2","size":"3.2","align":"none","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"30","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Education is a window to the world","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"none","size":"n","sizerem":"1.2","showtitle":"0","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","upper":"0","title":"Title text","mt":"0","mb":"40","pv":"0","ph":"0","tmb":"30","width":"2000","rounded":"0","gradient":"0","button":"0","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"0","bborder":"0","btext":"Read more","bfwcls":"medium","scheme":"light","content":"<p>Taking your online and distance learning to new heights. Accounting, graphic design, business management and more...</p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"button","type":"primary","size":"xlg","link":"#","target":"0","fw":"0","fwcls":"medium","lspacing":"0","wspacing":"0","rounded":"0","upper":"0","ml":"0","mr":"20","mt":"0","mb":"15","border":"0","center":"0","text":"Discover more","elname":"Button"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"button","type":"success","size":"xlg","link":"#","target":"0","fw":"0","fwcls":"medium","lspacing":"0","wspacing":"0","rounded":"0","upper":"0","ml":"0","mr":"0","mt":"0","mb":"15","border":"1","center":"0","text":"Apply now","elname":"Button"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","heroimg":"0","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"0","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"-70","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"0","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"boxes3d","columns":"4","type":"1","mt":"0","mb":"0","rounded":"1","gutter":"normal","elname":"Boxes - 3D"},"attr":[{"type":"mb2pb_subel","settings":{"id":"boxes3d_item","image":"https://dummyimage.com/700x700/eeeeee/333.jpg","title":"Take the time to learn new skills","link_target":"0","frontcolor":"rgb(99, 193, 50, 0.8)","backcolor":"rgb(99, 193, 50)","text":"Quonam, inquit, modo. Suo genere perveniant ad extremum; Ita multa dicunt, quae vix intellegam.","elname":"Box 3D"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxes3d_item","image":"https://dummyimage.com/700x700/eeeeee/333.jpg","title":"Enjoy online and distance learning","link_target":"0","frontcolor":"rgb(229, 57, 69, 0.8)","backcolor":"rgb(229, 57, 69)","text":"Graece donan, Latine voluptatem vocant. Minime vero istorum quidem, inquit. Nihil opus est exemplis.","elname":"Box 3D"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxes3d_item","image":"https://dummyimage.com/700x700/eeeeee/333.jpg","title":"Get professional certificates","link_target":"0","frontcolor":"rgb(30, 150, 252, 0.8)","backcolor":"rgb(30, 150, 252)","text":"Graece donan, Latine voluptatem vocant. Minime vero istorum quidem, inquit. Sed potestne rerum maior.","elname":"Box 3D"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxes3d_item","image":"https://dummyimage.com/700x700/eeeeee/333.jpg","title":"Learn from the best teachers","link_target":"0","frontcolor":"rgb(255, 189, 0, 0.8)","backcolor":"rgb(255, 189, 0)","text":"Cur post Tarentum ad Archytam. Nihil opus est exemplis hoc facere longius. Erat enim Polemonis. ","elname":"Box 3D"},"attr":[]}]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","heroimg":"0","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"30","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"1","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h3","size":"2.3","align":"none","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"30","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Move e-learning forward","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"none","size":"n","sizerem":"1","showtitle":"0","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","upper":"0","title":"Title text","mt":"0","mb":"40","pv":"0","ph":"0","tmb":"30","width":"2000","rounded":"0","gradient":"0","button":"0","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"0","bborder":"0","btext":"Read more","bfwcls":"medium","scheme":"light","content":"<p>Tubulo putas dicere. Honesta oratio, Socratica, Platonis. Praesent sapien massa, convallis a  nec, egestas non nisi. Nulla porttitor accumsan tincidunt. Curabitur aliquet quam id dui posuere blandit. Vivamus magna justo,  eget consectetur sed, convallis at tellus. Proin eget tortor risus. Lorem  dolor sit, consectetur adipiscing elit.</p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"button","type":"primary","size":"lg","link":"#","target":"0","fw":"0","fwcls":"medium","lspacing":"0","wspacing":"0","rounded":"0","upper":"0","ml":"0","mr":"0","mt":"0","mb":"30","border":"0","center":"0","text":"Learn more","elname":"Button"},"attr":[]}]},{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"10","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"boxesicon","columns":"2","gutter":"normal","type":"4","color":"primary","rounded":"0","tfs":"1","wave":"0","height":"0","mt":"64","mb":"0","boxmb":"0","linkbtn":"0","desc":"1","elname":"Boxes - icon"},"attr":[{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-graph2","title":"Sed ad rem redeamus","link_target":"0","content":"Immo videri fortasse. Si enim ad populum me vocas.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-global","title":"Latine voluptatem vocant","link_target":"0","content":"Nihil opus est exemplis hoc facere longius malane.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-notebook","title":"Graece donan","link_target":"0","content":"Suo genere perveniant ad extremum ta multa dicunt.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-mouse","title":"Cur post Tarentum","link_target":"0","content":"Minime vero istorum quidem, inquit. Nihil opus est.","elname":"Box icon"},"attr":[]}]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","bgimage":"","heroimg":"0","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"60","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h3","size":"2.3","align":"center","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"40","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Explore top courses","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"courses","limit":"8","excourses":"0","excats":"0","extags":"0","carousel":"1","columns":"4","sloop":"0","snav":"1","sdots":"0","autoplay":"0","pausetime":"5000","animtime":"450","desclimit":"25","titlelimit":"6","gutter":"normal","linkbtn":"0","prestyle":"none","mt":"0","mb":"30","coursestudentscount":"1","coursinstructor":"1","courseprice":"1","elname":"Courses"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","heroimg":"0","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"60","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h3","size":"2.3","align":"center","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"30","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Top categories","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"center","size":"n","sizerem":"1","showtitle":"0","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","upper":"0","title":"Title text","mt":"0","mb":"40","pv":"0","ph":"0","tmb":"30","width":"736","rounded":"0","gradient":"0","button":"0","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"0","bborder":"0","btext":"Read more","bfwcls":"medium","scheme":"light","content":"<p>New Learning has over 1 200 courses available. All of courses have been designed by subject matter experts to give you an interactive and enjoyable learning experience.</p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"boxesimg","columns":"4","type":"3","mt":"0","mb":"0","desc":"0","rounded":"1","tfs":"1.4","linkbtn":"0","btntype":"primary","btnsize":"normal","btnrounded":"0","btnborder":"0","btntext":"0","imgwidth":"800","gutter":"normal","elname":"Boxes - image"},"attr":[{"type":"mb2pb_subel","settings":{"id":"boxesimg_item","image":"https://dummyimage.com/700x1060/d57a44/333.jpg","link":"#","description":"Box description here...","link_target":"0","scheme":"dark","color":"rgba(42, 42, 42, 0.5)","text":"Architecture and design","elname":"Box image"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesimg_item","image":"https://dummyimage.com/700x1060/93abbb/333.jpg","link":"#","description":"Box description here...","link_target":"0","scheme":"dark","color":"rgba(42, 42, 42, 0.5)","text":"Business and economy","elname":"Box image"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesimg_item","image":"https://dummyimage.com/700x1060/5db9e5/333.jpg","link":"#","description":"Box description here...","link_target":"0","scheme":"dark","color":"rgba(42, 42, 42, 0.5)","text":"Mathematics and data","elname":"Box image"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesimg_item","image":"https://dummyimage.com/700x1060/d5bcb0/333.jpg","link":"#","description":"Box description here...","link_target":"0","scheme":"dark","color":"rgba(42, 42, 42, 0.5)","text":"Social sciences","elname":"Box image"},"attr":[]}]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(244, 244, 244)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","heroimg":"0","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"60","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"text","align":"none","size":"lg","sizerem":"1","color":"rgb(84, 84, 84)","showtitle":"1","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"2.3","upper":"0","title":"Featured Instructors","bgcolor":"rgb(255, 189, 0)","mt":"0","mb":"30","pv":"30","ph":"30","tmb":"30","width":"2000","rounded":"1","gradient":"0","button":"1","btype":"inverse","bsize":"lg","link":"#","target":"0","brounded":"0","bmt":"20","bborder":"1","btext":"Become an instructor","bfwcls":"medium","scheme":"light","content":"<p>Laboro autem non sine causa. Lstic sum inquit. Mihi inquam qui te id ipsum rogavi. Contineo me ab exemplis. Duo enim genera quae erant, fecit tria. Videsne quam sit magna dissensio. Pollicetur certe.</p>","elname":"Text"},"attr":[]}]},{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"teachers","limit":"4","exteachers":"0","carousel":"1","columns":"2","sloop":"0","snav":"1","sdots":"0","autoplay":"0","pausetime":"5000","animtime":"450","desclimit":"25","titlelimit":"6","gutter":"normal","mt":"0","mb":"30","elname":"Teachers"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","heroimg":"0","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"60","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h3","size":"2.3","align":"center","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"30","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Student reviews","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"center","size":"n","sizerem":"1","showtitle":"0","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","upper":"0","title":"Title text","mt":"0","mb":"40","pv":"0","ph":"0","tmb":"30","width":"785","rounded":"0","gradient":"0","button":"0","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"0","bborder":"0","btext":"Read more","bfwcls":"medium","scheme":"light","content":"<p>New Learning theme provides advanced course rating and review system. Reviews system lets your students share their honest feedback on your Moodle website.</p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"reviews","limit":"8","carousel":"1","userimg":"0","columns":"3","sloop":"0","snav":"1","sdots":"0","autoplay":"0","pausetime":"5000","animtime":"450","desclimit":"25","titlelimit":"6","gutter":"normal","mt":"0","mb":"30","elname":"Reviews"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgba(29, 53, 87, 0.94)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"dark","bgimage":"https://dummyimage.com/1900x800/e9eaea/333.jpg","heroimg":"0","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"60","pb":"0","fw":"0","va":"0","parallax":"1","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"1","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h3","size":"2.3","align":"none","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"30","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Discover your future","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"none","size":"n","sizerem":"1","showtitle":"0","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","upper":"0","title":"Title text","mt":"0","mb":"40","pv":"0","ph":"0","tmb":"30","width":"2000","rounded":"0","gradient":"0","button":"0","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"0","bborder":"0","btext":"Read more","bfwcls":"medium","scheme":"light","content":"<p>Tubulo putas dicere. Honesta oratio, Socratica, Platonis etiam. Praesent sapien massa, convallis a pellentesque nec, egestas non nisi. Nulla porttitor accumsan tincidunt. Curabitur aliquet quam id dui posuere blandit. Vivamus magna. Summus dolor plures dies manere non potest? Aliud igitur esse censet gaudere, aliud non dolere. Age, inquies, ista parva sunt. At coluit ipse amicitias. </p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"button","type":"primary","size":"lg","link":"#","target":"0","fw":"0","fwcls":"medium","lspacing":"0","wspacing":"0","rounded":"0","upper":"0","ml":"0","mr":"25","mt":"0","mb":"15","border":"0","center":"0","text":"Begin exploring","elname":"Button"},"attr":[]}]},{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"videoweb","width":"800","videourl":"https://youtu.be/3ORsUGVNxGs","ratio":"16:9","mt":"0","mb":"30","bgimage":"1","bgimageurl":"https://dummyimage.com/900x508/a4a6a8/333.jpg","iconcolor":"rgb(29, 53, 87)","bgcolor":"rgba(255, 255, 255, 0.46)","elname":"Video - web"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgba(244, 244, 244, 0.89)","bgfixed":"0","colgutter":"xl","prbg":"0","scheme":"light","bgimage":"","heroimg":"0","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"30","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h3","size":"1","align":"center","fwcls":"bold","lhcls":"global","lspacing":"0","wspacing":"0","upper":"1","mt":"0","mb":"17","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Proudly collaborate with","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"carousel","mt":"0","mb":"0","prestyle":"nlearning","columns":"5","gutter":"normal","linkbtn":"0","title":"0","titlefs":"1.4","imgwidth":"101","mobcolumns":"1","desc":"0","sloop":"1","snav":"0","sdots":"0","autoplay":"1","pausetime":"5000","animtime":"450","elname":"Carousel"},"attr":[{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"1609703107285","image":"https://dummyimage.com/400x300/eeeeee/333.jpg","title":"Title text","desc":"Description text","elname":"Carousel item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"1609703107286","image":"https://dummyimage.com/400x300/eeeeee/333.jpg","title":"Title text","desc":"Description text","elname":"Carousel item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"1609703107287","image":"https://dummyimage.com/400x300/eeeeee/333.jpg","title":"Title text","desc":"Description text","elname":"Carousel item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"1609703107288","image":"https://dummyimage.com/400x300/eeeeee/333.jpg","title":"Title text","desc":"Description text","elname":"Carousel item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"1609703107289","image":"https://dummyimage.com/400x300/eeeeee/333.jpg","title":"Title text","desc":"Description text","elname":"Carousel item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"carousel_item","pbid":"1609703356901","image":"https://dummyimage.com/400x300/eeeeee/333.jpg","title":"Title text","desc":"Description text","elname":"Carousel item"},"attr":[]}]}]}]}]}]}]'
		),
		array(
			'name' => 'school-4',
			'thumb' => 'school-4',
			'tags' => 'school',
			'data' => '[{"type":"mb2pb_page","settings":{},"attr":[{"type":"mb2pb_section","settings":{"id":"section","size":"4","margin":"","bgcolor":"","prbg":"0","scheme":"light","bgimage":"","bgel1":"","bgel2":"","bgel1s":"500","bgel2s":"500","bgel1top":"200","bgel2top":"200","bgel1left":"0","bgel2left":"0","pt":"0","sectionhidden":"0","sectionlang":"","pb":"0","sectionaccess":"0","custom_class":"","template":"","elname":"Section"},"attr":[{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","bgimage":"","bordert":"0","borderb":"0","bordertcolor":"#dddddd","borderbcolor":"#dddddd","heroimg":"1","heroimgurl":"https://dummyimage.com/1500x950/e0e5ee/333.jpg","herov":"center","herow":"750","herohpos":"left","heroml":"51","heromt":"-68","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0, 0, 0, 0.05)","bgvideo":"","rowhidden":"0","rowlang":"","pt":"200","pb":"249","fw":"0","va":"0","parallax":"0","rowaccess":"0","custom_class":"","template":"","wave":"2","wavecolor":"rgb(88, 0, 255)","wavepos":"0","wavefliph":"1","wavetop":"0","wavewidth":"299","waveheight":"174","waveover":"0","mt":"0","gradient":"0","graddeg":"90","gradloc1":"0","gradloc2":"100","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"1","moborder":"0","align":"left","alignc":"none","height":"0","width":"562","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h2","size":"3.2","align":"left","btext":"","atext":"","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","nline":"0","mt":"0","mb":"30","width":"2000","color":"","acolor":"","bcolor":"","afwcls":"global","bfwcls":"global","custom_class":"","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","template":"","content":"Study online with New Learning","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"left","size":"n","sizerem":"1","color":"","showtitle":"0","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","tcolor":"","upper":"0","title":"Title text","bgcolor":"","mt":"0","mb":"40","pv":"0","ph":"0","tmb":"30","width":"2000","rounded":"0","gradient":"0","button":"0","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"0","bborder":"0","btext":"Read more","bfwcls":"medium","scheme":"light","custom_class":"","template":"","content":"<p>Taking your online and distance learning to new heights. Accounting, graphic design, business management and more...</p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"button","type":"primary","size":"xlg","link":"#","target":"0","isicon":"0","icon":"","fw":"0","fwcls":"medium","lspacing":"0","wspacing":"0","rounded":"0","upper":"0","custom_class":"","ml":"0","mr":"20","mt":"0","mb":"20","border":"0","center":"0","color":"","bgcolor":"","borcolor":"","bghcolor":"","hcolor":"","borhcolor":"","template":"","text":"Discover more","elname":"Button"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(88, 0, 255)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"dark","bgimage":"","bordert":"0","borderb":"0","bordertcolor":"#dddddd","borderbcolor":"#dddddd","heroimg":"0","heroimgurl":"","herov":"center","herow":"750","herohpos":"left","heroml":"50","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","bgvideo":"","rowhidden":"0","rowlang":"","pt":"60","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","custom_class":"","template":"","wave":"none","wavecolor":"","wavepos":"1","wavefliph":"0","wavetop":"0","wavewidth":"276","waveheight":"76","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradloc1":"0","gradloc2":"100","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"boxesicon","columns":"4","gutter":"normal","type":"4","color":"primary","ccolor":"rgb(255, 255, 255)","rounded":"0","tfs":"1.6","tfw":"global","wave":"0","height":"0","mt":"0","mb":"0","boxmb":"0","linkbtn":"0","btntext":"","desc":"1","custom_class":"","template":"","elname":"Boxes - icon"},"attr":[{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-study","type":"","title":"Online deegree","link":"","color":"","ccolor":"","link_target":"0","target":"","btntext":"","template":"","content":"Immo videri fortasse. Si enim ad populum me vocas, eum. Etenim semper illud.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-medal","type":"","title":"Certificates","link":"","color":"","ccolor":"","link_target":"0","target":"","btntext":"","template":"","content":"Traditur, inquit, ab Epicuro ratio neglegendi doloris. Restinguet citius, ardentem acceperit.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-cloud-download","type":"","title":"Audio books","link":"","color":"","ccolor":"","link_target":"0","target":"","btntext":"","template":"","content":"Etenim semper illud extra est, quod arte comprehenditur. Sed virtutem ipsam inchoavit.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-film","type":"","title":"Podcasts","link":"","color":"","ccolor":"","link_target":"0","target":"","btntext":"","template":"","content":"Philosophi autem in suis lectulis plerumque moriuntur. Ita nemo beato beatior.","elname":"Box icon"},"attr":[]}]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","bgimage":"","bordert":"0","borderb":"0","bordertcolor":"#dddddd","borderbcolor":"#dddddd","heroimg":"0","heroimgurl":"","herov":"center","herow":"750","herohpos":"left","heroml":"50","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.1)","bgvideo":"","rowhidden":"0","rowlang":"","pt":"200","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","custom_class":"","template":"","wave":"2","wavecolor":"rgb(88, 0, 255)","wavepos":"1","wavefliph":"0","wavetop":"0","wavewidth":"352","waveheight":"124","waveover":"0","mt":"0","gradient":"0","graddeg":"90","gradloc1":"0","gradloc2":"100","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"0","moborder":"2","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"image","align":"none","center":"1","width":"400","alt":"","mt":"0","mb":"30","caption":"0","captiontext":"Caption text here","link":"","link_target":"0","custom_class":"","template":"","text":"https://dummyimage.com/800x850/e0e5ee/333.jpg","elname":"Image"},"attr":[]}]},{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h3","size":"2.3","align":"none","btext":"","atext":"","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","nline":"0","mt":"0","mb":"30","width":"2000","color":"","acolor":"","bcolor":"","afwcls":"global","bfwcls":"global","custom_class":"","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","template":"","content":"Learn by doing","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"accordion","show_all":"0","builder":"1","type":"default","size":"m","padding":"0","rounded":"1","custom_class":"","tfs":"1","tfw":"bold","tcolor":"rgb(255, 255, 255)","thcolor":"","hbgcolor":"rgb(88, 0, 255)","hbghcolor":"rgb(255, 196, 61)","cbgcolor":"","iconcolor":"","iconhcolor":"","scheme":"light","isicon":"0","icon":"fa fa-trophy","accordion_active":"1","mt":"0","mb":"30","parent":"1","template":"","elname":"Accordion"},"attr":[{"type":"mb2pb_subel","settings":{"id":"accordion_item","title":"Construct knowledge for themselves","icon":"","template":"","text":"<p>Praesent sapien massa, convallis a pellentesque nec, egestas non nisi. Quisque velit nisi, pretium ut lacinia in, elementum id enim. Donec rutrum congue leo eget malesuada. Curabitur aliquet quam id dui posuere blandit. Curabitur aliquet quam id dui posuere blandit. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>","elname":"Accordion item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"accordion_item","title":"Technique that calls you to actively engage with the material","icon":"","template":"","text":"<p>Traditur, inquit, ab Epicuro ratio neglegendi doloris. Restinguet citius, si ardentem acceperit. Nosti, credo, illud: Nemo pius est, qui pietatem-; Itaque contra est, ac dicitis; Nihil opus est exemplis hoc facere longius. Duo Reges: constructio interrete. </p>","elname":"Accordion item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"accordion_item","title":"Personalized learning experiences","icon":"","template":"","text":"<p>Sed quae tandem ista ratio est? Suam denique cuique naturam esse ad vivendum ducem. Contineo me ab exemplis. Egone quaeris, inquit, quid sentiam? Quid ad utilitatem tantae pecuniae? Philosophi autem in suis lectulis plerumque moriuntur.</p>","elname":"Accordion item"},"attr":[]}]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","bgimage":"","bordert":"0","borderb":"0","bordertcolor":"#dddddd","borderbcolor":"#dddddd","heroimg":"0","heroimgurl":"","herov":"center","herow":"750","herohpos":"left","heroml":"50","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","bgvideo":"","rowhidden":"0","rowlang":"","pt":"60","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","custom_class":"","template":"","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"236","waveheight":"18","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradloc1":"0","gradloc2":"100","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h3","size":"2.3","align":"center","btext":"","atext":"","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","nline":"0","mt":"0","mb":"30","width":"2000","color":"","acolor":"","bcolor":"","afwcls":"global","bfwcls":"global","custom_class":"","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","template":"","content":"You can learn everything you want","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"center","size":"n","sizerem":"1","color":"","showtitle":"0","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","tcolor":"","upper":"0","title":"Title text","bgcolor":"","mt":"0","mb":"40","pv":"0","ph":"0","tmb":"30","width":"2000","rounded":"0","gradient":"0","button":"0","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"0","bborder":"0","btext":"Read more","bfwcls":"medium","scheme":"light","custom_class":"","template":"","content":"<p>Explore our featured courses.</p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"boxesicon","columns":"4","gutter":"normal","type":"5","color":"primary","ccolor":"","rounded":"1","tfs":"1.6","tfw":"global","wave":"1","height":"307","mt":"0","mb":"0","boxmb":"0","linkbtn":"0","btntext":"","desc":"0","custom_class":"","template":"","elname":"Boxes - icon"},"attr":[{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-vector","type":"","title":"Vector graphics from  scratch","link":"#","color":"rgb(0, 0, 78)","ccolor":"rgb(0, 0, 78)","link_target":"0","target":"","btntext":"","template":"","content":"Box content here.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-camera","type":"","title":"Complete guide to  photo editing","link":"#","color":"rgb(33, 211, 238)","ccolor":"rgb(33, 211, 238)","link_target":"0","target":"","btntext":"","template":"","content":"Box content here.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-network","type":"","title":"IT networking  fundamentals","link":"#","color":"rgb(195, 0, 0)","ccolor":"rgb(195, 0, 0)","link_target":"0","target":"","btntext":"","template":"","content":"Box content here.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-shield","type":"","title":"Cyber Security","link":"#","color":"rgb(29, 76, 222)","ccolor":"rgb(29, 76, 222)","link_target":"0","target":"","btntext":"","template":"","content":"Box content here.","elname":"Box icon"},"attr":[]}]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","bgimage":"","bordert":"0","borderb":"0","bordertcolor":"#dddddd","borderbcolor":"#dddddd","heroimg":"0","heroimgurl":"","herov":"center","herow":"750","herohpos":"left","heroml":"50","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.1)","bgvideo":"","rowhidden":"0","rowlang":"","pt":"60","pb":"134","fw":"0","va":"0","parallax":"0","rowaccess":"0","custom_class":"","template":"","wave":"2","wavecolor":"rgb(255, 248, 231)","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"327","waveheight":"132","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradloc1":"0","gradloc2":"100","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"0","moborder":"2","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h3","size":"2.3","align":"none","btext":"","atext":"","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","nline":"0","mt":"0","mb":"30","width":"2000","color":"","acolor":"","bcolor":"","afwcls":"global","bfwcls":"global","custom_class":"","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","template":"","content":"Our achivements","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"none","size":"n","sizerem":"1","color":"","showtitle":"0","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","tcolor":"","upper":"0","title":"Title text","bgcolor":"","mt":"0","mb":"30","pv":"0","ph":"0","tmb":"30","width":"2000","rounded":"0","gradient":"0","button":"0","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"0","bborder":"0","btext":"Read more","bfwcls":"medium","scheme":"light","custom_class":"","template":"","content":"<p>Nunc de hominis summo bono quaeritur; Quid enim est a Chrysippo praetermissum in Stoicis? Sit enim idem caecus, debilis. Nam Pyrrho, Aristo, Erillus iam diu abiecti. Beatus sibi videtur esse moriens. Restatis igitur vos.</p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"animnum","columns":"2","mt":"0","mb":"0","pv":"8","gutter":"normal","icon":"0","center":"0","size_number":"2.6","size_icon":"3.15","size_title":"1","color_icon":"","color_number":"rgb(51, 51, 51)","nfwcls":"bold","tfwcls":"global","tlhcls":"global","color_title":"","color_subtitle":"","color_bg":"rgba(255, 255, 255, 0)","subtitle":"0","nopadding":"1","custom_class":"","aspeed":"10000","height":"0","template":"","elname":"Animated number"},"attr":[{"type":"mb2pb_subel","settings":{"id":"animnum_item","number":"8500","icon":"fa fa-graduation-cap","title":"students enrolled in our courses around the world.","color_icon":"","color_number":"","color_title":"","color_subtitle":"","color_bg":"","subtitle":"Subtitle here","template":"","elname":"Animated number item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"animnum_item","number":"1200","icon":"fa fa-graduation-cap","title":"high quality course divided into 50 categories. ","color_icon":"","color_number":"","color_title":"","color_subtitle":"","color_bg":"","subtitle":"Subtitle here","template":"","elname":"Animated number item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"animnum_item","number":"96","icon":"fa fa-graduation-cap","title":"% of our customers rated 5-star our courses over 3 years.","color_icon":"","color_number":"","color_title":"","color_subtitle":"","color_bg":"","subtitle":"Subtitle here","template":"","elname":"Animated number item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"animnum_item","number":"75","icon":"fa fa-graduation-cap","title":"% learners leads to better jobs with our courses.","color_icon":"","color_number":"","color_title":"","color_subtitle":"","color_bg":"","subtitle":"Subtitle here","template":"","elname":"Animated number item"},"attr":[]}]}]},{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"0","moborder":"1","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"image","align":"none","center":"1","width":"425","alt":"","mt":"0","mb":"30","caption":"0","captiontext":"Caption text here","link":"","link_target":"0","custom_class":"","template":"","text":"https://dummyimage.com/850x850/e0e5ee/333.jpghttps://dummyimage.com/800x850/e0e5ee/333.jpg","elname":"Image"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(255, 248, 231)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","bgimage":"","bordert":"0","borderb":"0","bordertcolor":"#dddddd","borderbcolor":"#dddddd","heroimg":"0","heroimgurl":"","herov":"center","herow":"750","herohpos":"left","heroml":"50","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.1)","bgvideo":"","rowhidden":"0","rowlang":"","pt":"60","pb":"77","fw":"0","va":"0","parallax":"0","rowaccess":"0","custom_class":"","template":"","wave":"2","wavecolor":"rgb(0, 14, 84)","wavepos":"0","wavefliph":"1","wavetop":"0","wavewidth":"261","waveheight":"123","waveover":"0","mt":"0","gradient":"0","graddeg":"90","gradloc1":"0","gradloc2":"100","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"0","moborder":"2","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"image","align":"none","center":"1","width":"493","alt":"","mt":"0","mb":"30","caption":"0","captiontext":"Caption text here","link":"","link_target":"0","custom_class":"","template":"","text":"https://dummyimage.com/955x852/e0e5ee/333.jpg","elname":"Image"},"attr":[]}]},{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h3","size":"2.3","align":"none","btext":"","atext":"","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","nline":"0","mt":"0","mb":"30","width":"1131","color":"","acolor":"","bcolor":"","afwcls":"global","bfwcls":"global","custom_class":"","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","template":"","content":"You can learn anytime anywhere, 100% online","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"none","size":"n","sizerem":"1","color":"","showtitle":"0","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","tcolor":"","upper":"0","title":"Title text","bgcolor":"","mt":"0","mb":"30","pv":"0","ph":"0","tmb":"30","width":"2000","rounded":"0","gradient":"0","button":"0","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"0","bborder":"0","btext":"Read more","bfwcls":"medium","scheme":"light","custom_class":"","template":"","content":"<p>Qui est in parvis malis. Duo Reges: constructio interrete. Unum est sine dolore esse, alterum cum voluptate. Quis negat? Nulla erit controversia. Illud non continuo, ut aeque incontentae ipsum elegantius poni eo dant clariora indicia naturae.</p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"listicon","style":"disc","icon":"ri-check-fill","bgcolor":"rgb(85, 146, 66)","iconcolor":"rgb(88, 0, 255)","textcolor":"","border":"0","borderw":"2","bordercolor":"","horizontal":"0","align":"none","fwcls":"bold","isize":"3.62","space":"0","iconbg":"0","fs":"1","custom_class":"","mt":"0","mb":"20","template":"","elname":"List icon"},"attr":[{"type":"mb2pb_subel","settings":{"id":"listicon_item","icon":"","bgcolor":"","iconcolor":"","textcolor":"","bordercolor":"","link":"","link_target":"0","template":"","text":"Self-paced learning","elname":"List icon item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"listicon_item","icon":"","bgcolor":"","iconcolor":"","textcolor":"","bordercolor":"","link":"","link_target":"0","template":"","text":"Courses made for desktop and mobile devices","elname":"List icon item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"listicon_item","icon":"","bgcolor":"","iconcolor":"","textcolor":"","bordercolor":"","link":"","link_target":"0","template":"","text":"Multilingual courses","elname":"List icon item"},"attr":[]}]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(0, 14, 84)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"dark","bgimage":"","bordert":"0","borderb":"0","bordertcolor":"#dddddd","borderbcolor":"#dddddd","heroimg":"0","heroimgurl":"","herov":"center","herow":"750","herohpos":"left","heroml":"50","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","bgvideo":"","rowhidden":"0","rowlang":"","pt":"60","pb":"150","fw":"0","va":"0","parallax":"0","rowaccess":"0","custom_class":"","template":"","wave":"2","wavecolor":"rgb(247, 247, 247)","wavepos":"0","wavefliph":"1","wavetop":"0","wavewidth":"248","waveheight":"133","waveover":"0","mt":"0","gradient":"0","graddeg":"90","gradloc1":"0","gradloc2":"100","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"center","alignc":"none","height":"0","width":"2000","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h3","size":"2.3","align":"none","btext":"","atext":"","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","nline":"0","mt":"0","mb":"30","width":"2000","color":"","acolor":"","bcolor":"","afwcls":"global","bfwcls":"global","custom_class":"","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","template":"","content":"Let\'s build something together","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"none","size":"n","sizerem":"1","color":"","showtitle":"0","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","tcolor":"","upper":"0","title":"Title text","bgcolor":"","mt":"0","mb":"40","pv":"0","ph":"0","tmb":"30","width":"824","rounded":"0","gradient":"0","button":"0","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"0","bborder":"0","btext":"Read more","bfwcls":"medium","scheme":"light","custom_class":"","template":"","content":"<p>Qui est in parvis malis. Duo Reges: constructio interrete. Unum est sine dolore esse, alterum cum voluptate. Quis negat? Nulla erit controversia. Illud non continuo, ut aeque incontentae.</p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"button","type":"primary","size":"lg","link":"#","target":"0","isicon":"0","icon":"","fw":"0","fwcls":"medium","lspacing":"0","wspacing":"0","rounded":"0","upper":"0","custom_class":"","ml":"0","mr":"0","mt":"0","mb":"15","border":"0","center":"0","color":"","bgcolor":"","borcolor":"","bghcolor":"","hcolor":"","borhcolor":"","template":"","text":"Buy theme now","elname":"Button"},"attr":[]}]}]}]}]}]'
		),
		array(
			'name' => 'school-5',
			'thumb' => 'school-5',
			'tags' => 'school',
			'data' => '[{"type":"mb2pb_page","settings":{},"attr":[{"type":"mb2pb_section","settings":{"id":"section","size":"4","prbg":"0","scheme":"light","bgel1":"mb2sampledata:2021/05/bgel1","bgel2":"mb2sampledata:2021/05/bgel2","bgel1s":"687","bgel2s":"372","bgel1top":"858","bgel2top":"814","bgel1left":"69","bgel2left":"-18","pt":"0","sectionhidden":"0","pb":"0","sectionaccess":"0","elname":"Section"},"attr":[{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(229, 229, 234)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","heroimg":"1","heroimgurl":"https://dummyimage.com/1900x970/d3d2d8/333.jpg","herov":"center","herow":"1359","herohpos":"left","heroml":"22","heromt":"0","heroonsmall":"1","herogradl":"1","herogradr":"1","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0, 0, 0, 0.05)","rowhidden":"0","pt":"130","pb":"80","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"0","wavecolor":"#ffffff","wavepos":"1","wavefliph":"1","wavetop":"0","wavewidth":"269","waveheight":"21","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"735","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h2","size":"3.2","align":"none","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"20","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Ready to seriously improve your\nlearning?","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"none","size":"n","sizerem":"1.25","showtitle":"0","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","upper":"0","title":"Title text","mt":"0","mb":"30","pv":"0","ph":"0","tmb":"30","width":"2000","rounded":"0","gradient":"0","button":"0","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"0","bborder":"0","btext":"Read more","bfwcls":"medium","scheme":"light","content":"<p>Taking your online and distance learning to new heights. Accounting, graphic design, business management and more...</p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"search","placeholder":"What do you want to learn?","global":"0","rounded":"0","width":"750","border":"0","size":"n","mt":"0","mb":"30","elname":"Search"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"listicon","style":"disc","icon":"pe-7s-check","iconcolor":"rgb(230, 57, 70)","textcolor":"rgb(230, 57, 70)","border":"1","borderw":"2","bordercolor":"rgb(230, 57, 70)","horizontal":"1","fwcls":"medium","iconbg":"0","mt":"0","mb":"30","elname":"List icon"},"attr":[{"type":"mb2pb_subel","settings":{"id":"listicon_item","link_target":"0","text":"Self-paced learning","elname":"List icon item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"listicon_item","link_target":"0","text":"Courses made for desktop and mobile devices","elname":"List icon item"},"attr":[]}]},{"type":"mb2pb_el","settings":{"id":"image","align":"none","center":"0","width":"330","mt":"0","mb":"30","caption":"0","captiontext":"Caption text here","link_target":"0","text":"https://dummyimage.com/656x80/eeeeee/333.jpg","elname":"Image"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","heroimg":"0","herov":"center","herow":"750","herohpos":"left","heroml":"50","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"60","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"text","align":"none","size":"n","sizerem":"1","showtitle":"1","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","upper":"0","title":"Online deegree","bgcolor":"rgb(31, 0, 82)","mt":"0","mb":"0","pv":"30","ph":"30","tmb":"20","width":"2000","rounded":"1","gradient":"1","button":"1","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"10","bborder":"0","btext":"Read more","bfwcls":"global","scheme":"dark","content":"<p>Ut optime, secundum naturam affectum esse possit. Non laboro, inquit, de nomine. Quippe: habes enim a rhetoribus. Cur id non ita fit? Haec quo modo conveniant, non sane intellego. Quare ad ea primum. </p>","elname":"Text"},"attr":[]}]},{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"text","align":"none","size":"n","sizerem":"1","showtitle":"1","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","upper":"0","title":"Certificate programs","bgcolor":"rgb(255, 123, 0)","mt":"0","mb":"0","pv":"30","ph":"30","tmb":"20","width":"2000","rounded":"1","gradient":"1","button":"1","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"10","bborder":"0","btext":"Read more","bfwcls":"global","scheme":"dark","content":"<p>Ut optime, secundum naturam affectum esse possit. Non laboro, inquit, de nomine. Quippe: habes enim a rhetoribus. Cur id non ita fit? Haec quo modo conveniant, non sane intellego. Quare ad ea primum. </p>","elname":"Text"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","heroimg":"0","herov":"center","herow":"750","herohpos":"left","heroml":"50","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"0","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"boxesimg","columns":"1","type":"5","mt":"0","mb":"0","desc":"1","rounded":"1","tfs":"1.4","linkbtn":"2","btntype":"primary","btnsize":"normal","btnfwcls":"global","btnrounded":"0","btnborder":"0","btntext":"Read more","imgwidth":"800","gutter":"normal","elname":"Boxes - image"},"attr":[{"type":"mb2pb_subel","settings":{"id":"boxesimg_item","image":"https://dummyimage.com/1900x910/b2bfcc/333.jpg","link":"#","description":"Nummus in Croesi divitiis obscuratur, pars est tamen divitiarum. Expectoque quid ad id, quod quaerebam, respondeas. Hoc non est positum in nostra actione. Falli igitur possumus. Sed in rebus apertissimis nimium longi sumus. Proclivi currit oratio. Nunc vides, quid faciat.","link_target":"0","scheme":"light","color":"rgb(238, 245, 249)","text":"Get ready for a career","elname":"Box image"},"attr":[]}]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","heroimg":"0","herov":"center","herow":"750","herohpos":"left","heroml":"50","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"0","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"coursetabs","limit":"12","filtertype":"category","excats":"0","extags":"0","columns":"4","gutter":"normal","mt":"0","mb":"30","catdesc":"1","coursecount":"1","carousel":"1","sloop":"0","snav":"1","sdots":"0","autoplay":"0","pausetime":"5000","animtime":"450","elname":"Course tabs"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","heroimg":"0","herov":"center","herow":"750","herohpos":"left","heroml":"50","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"0","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"boxesimg","columns":"1","type":"5","mt":"0","mb":"0","desc":"1","rounded":"1","tfs":"1.4","linkbtn":"2","btntype":"inverse","btnsize":"normal","btnfwcls":"global","btnrounded":"0","btnborder":"0","btntext":"Start learning today","imgwidth":"800","gutter":"normal","elname":"Boxes - image"},"attr":[{"type":"mb2pb_subel","settings":{"id":"boxesimg_item","image":"https://dummyimage.com/1900x910/e48d28/333.jpg","link":"#","description":"Nummus in Croesi divitiis obscuratur, pars est tamen divitiarum. Expectoque quid ad id, quod quaerebam, respondeas. Hoc non est positum in nostra actione. Falli igitur possumus. Sed in rebus apertissimis nimium longi sumus. Proclivi currit oratio. Nunc vides, quid faciat.","link_target":"0","scheme":"dark","color":"rgb(226, 140, 39)","text":"Make the most of your online learning experience","elname":"Box image"},"attr":[]}]}]}]}]}]}]'
		)
	)
);

define( 'LOCAL_MB2BUILDER_IMPORT_LAYOUTS_SCHOOL', base64_encode( serialize( $mb2_settings ) ) );
