<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package    local_mb2builder
 * @copyright  2018 - 2020 Mariusz Boloz (mb2moodle.com/)
 * @license   Commercial https://themeforest.net/licenses
 */

defined( 'MOODLE_INTERNAL' ) || die();

$mb2_settings = array(
	'id' => 'iconboxes',
	'title' => get_string( 'iconboxes', 'local_mb2builder' ),
	'items' => array(
		array(
			'name' => 'iconboxes-1',
			'thumb' => 'iconboxes-1',
			'tags' => 'iconboxes',
			'data' => '[{"type":"mb2pb_row","settings":{"id":"row","rowheader":"0","rowheader_content":"Row title here","rowheader_textcolor":"","rowheader_bgcolor":"","rowheader_mb":"30","bgcolor":"rgb(244, 244, 244)","prbg":"0","scheme":"light","bgimage":"","rowhidden":"0","rowlang":"","pt":"70","pb":"10","fw":"0","rowaccess":"0","custom_class":"","template":"1","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"col":"12"},"attr":[{"type":"mb2pb_el","settings":{"id":"boxesicon","columns":"4","gutter":"normal","type":"1","color":"primary","mt":"0","mb":"0","linkbtn":"0","btntext":"","desc":"1","custom_class":"","template":"1","elname":"Boxes - icon"},"attr":[{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-help2","type":"","title":"Nullam tincidunt","link":"","color":"","link_target":"0","target":"","btntext":"","template":"","content":"Pellentesque in ipsum id orci porta dapibus. Quisque velit nisi, pretium ut lacinia in, elementum id enim.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-coffee","type":"","title":"Vivamus laoreet","link":"","color":"","link_target":"0","target":"","btntext":"","template":"","content":"Pellentesque in ipsum id orci porta dapibus. Quisque velit nisi, pretium ut lacinia in, elementum id enim.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-rocket","type":"","title":"Pellentesque habitant","link":"","color":"","link_target":"0","target":"","btntext":"","template":"","content":"Pellentesque in ipsum id orci porta dapibus. Quisque velit nisi, pretium ut lacinia in, elementum id enim.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"pe-7s-plugin","type":"","title":"Etiam rhoncus","link":"","color":"","link_target":"0","target":"","btntext":"","template":"","content":"Pellentesque in ipsum id orci porta dapibus. Quisque velit nisi, pretium ut lacinia in, elementum id enim.","elname":"Box icon"},"attr":[]}]}]}]}]'
		),
		array(
			'name' => 'iconboxes-2',
			'thumb' => 'iconboxes-2',
			'tags' => 'iconboxes',
			'data' => '[{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(255, 255, 255)","bgfixed":"0","colgutter":"s","prbg":"gradient20","scheme":"light","rowhidden":"0","pt":"70","pb":"10","fw":"0","rowaccess":"0","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","height":"0","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"title","tag":"h4","align":"center","issubtext":"0","subtext":"Subtext here","size":"n","sizerem":"2.4","fweight":"600","lspacing":"0","wspacing":"0","upper":"1","style":"1","mt":"0","mb":"30","content":"Etiam ultricies nisi vel augue","elname":"Title"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"center","size":"n","sizerem":"1","showtitle":"0","fweight":"400","lspacing":"0","wspacing":"0","upper":"0","title":"Title text","mt":"0","mb":"45","content":"<p>Sed augue ipsum, egestas nec, vestibulum et, malesuada adipiscing, dui. Quisque malesuada placerat nisl. Phasellus leo dolor, tempus non, auctor et, hendrerit quis, nisi. Maecenas vestibulum mollis diam. Integer tincidunt. Ut leo. Quisque ut nisi. Quisque malesuada placerat nisl.</p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"boxesicon","columns":"3","gutter":"normal","type":"2","color":"inverse","mt":"0","mb":"0","linkbtn":"0","desc":"1","elname":"Boxes - icon"},"attr":[{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"fa fa-university","title":"Nullam tincidunt","link_target":"0","content":"Pellentesque in ipsum id orci porta dapibus. Quisque velit nisi, pretium ut lacinia in, elementum id enim.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"fa fa-bullhorn","title":"Vivamus laoreet","link_target":"0","content":"Pellentesque in ipsum id orci porta dapibus. Quisque velit nisi, pretium ut lacinia in, elementum id enim.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"fa fa-graduation-cap","title":"Pellentesque habitant","link_target":"0","content":"Pellentesque in ipsum id orci porta dapibus. Quisque velit nisi, pretium ut lacinia in, elementum id enim.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"fa fa-users","title":"Etiam rhoncus","link_target":"0","content":"Pellentesque in ipsum id orci porta dapibus. Quisque velit nisi, pretium ut lacinia in, elementum id enim.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"fa fa-trophy","title":"Etiam rhoncus","link_target":"0","content":"Pellentesque in ipsum id orci porta dapibus. Quisque velit nisi, pretium ut lacinia in, elementum id enim.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"fa fa-bar-chart","title":"Etiam rhoncus","link_target":"0","content":"Pellentesque in ipsum id orci porta dapibus. Quisque velit nisi, pretium ut lacinia in, elementum id enim.","elname":"Box icon"},"attr":[]}]}]}]}]'
		),
		array(
			'name' => 'iconboxes-3',
			'thumb' => 'iconboxes-3',
			'tags' => 'iconboxes',
			'data' => '[{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(29, 53, 87)","bgfixed":"0","colgutter":"s","prbg":"strip4","scheme":"dark","rowhidden":"0","pt":"70","pb":"10","fw":"0","rowaccess":"0","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","height":"0","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"title","tag":"h4","align":"center","issubtext":"0","subtext":"Subtext here","size":"n","sizerem":"2.4","fweight":"600","lspacing":"0","wspacing":"0","upper":"1","style":"1","mt":"0","mb":"30","content":"Etiam ultricies nisi vel augue","elname":"Title"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"center","size":"n","sizerem":"1","showtitle":"0","fweight":"400","lspacing":"0","wspacing":"0","upper":"0","title":"Title text","mt":"0","mb":"45","content":"<p>Sed augue ipsum, egestas nec, vestibulum et, malesuada adipiscing, dui. Quisque malesuada placerat nisl. Phasellus leo dolor, tempus non, auctor et, hendrerit quis, nisi. Maecenas vestibulum mollis diam. Integer tincidunt. Ut leo. Quisque ut nisi. Quisque malesuada placerat nisl.</p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"boxesicon","columns":"3","gutter":"normal","type":"2","color":"primary","mt":"0","mb":"0","linkbtn":"0","desc":"1","elname":"Boxes - icon"},"attr":[{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"fa fa-university","title":"Nullam tincidunt","link_target":"0","content":"Pellentesque in ipsum id orci porta dapibus. Quisque velit nisi, pretium ut lacinia in, elementum id enim.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"fa fa-bullhorn","title":"Vivamus laoreet","link_target":"0","content":"Pellentesque in ipsum id orci porta dapibus. Quisque velit nisi, pretium ut lacinia in, elementum id enim.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"fa fa-graduation-cap","title":"Pellentesque habitant","link_target":"0","content":"Pellentesque in ipsum id orci porta dapibus. Quisque velit nisi, pretium ut lacinia in, elementum id enim.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"fa fa-users","title":"Etiam rhoncus","link_target":"0","content":"Pellentesque in ipsum id orci porta dapibus. Quisque velit nisi, pretium ut lacinia in, elementum id enim.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"fa fa-trophy","title":"Etiam rhoncus","link_target":"0","content":"Pellentesque in ipsum id orci porta dapibus. Quisque velit nisi, pretium ut lacinia in, elementum id enim.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"fa fa-bar-chart","title":"Etiam rhoncus","link_target":"0","content":"Pellentesque in ipsum id orci porta dapibus. Quisque velit nisi, pretium ut lacinia in, elementum id enim.","elname":"Box icon"},"attr":[]}]}]}]}]'
		),
		array(
			'name' => 'iconboxes-4',
			'thumb' => 'iconboxes-4',
			'tags' => 'iconboxes',
			'data' => '[{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgba(37, 47, 55, 0.9)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"dark","bgimage":"https://dummyimage.com/1900x1300/6f7076/333.jpg","rowhidden":"0","pt":"70","pb":"10","fw":"0","rowaccess":"0","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"left","height":"0","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"title","tag":"h4","align":"center","issubtext":"0","subtext":"Subtext here","size":"n","sizerem":"2.4","fweight":"600","lspacing":"0","wspacing":"0","upper":"0","style":"1","mt":"0","mb":"30","content":"Proin viverra ligula sit amet","elname":"Title"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"center","size":"n","sizerem":"1","showtitle":"0","fweight":"400","lspacing":"0","wspacing":"0","upper":"0","title":"Title text","mt":"0","mb":"30","content":"<p>Fusce vel dui. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Nunc nulla. Duis vel nibh at velit scelerisque suscipit. Praesent turpis. Etiam feugiat lorem non metus. Donec interdum, metus et hendrerit aliquet, dolor diam sagittis ligula, eget egestas libero turpis vel mi.  </p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"boxesicon","columns":"3","gutter":"normal","type":"3","color":"primary","mt":"0","mb":"0","linkbtn":"0","desc":"1","elname":"Boxes - icon"},"attr":[{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"fa fa-lightbulb-o","title":"Vivamus laoreet","link_target":"0","content":"Pellentesque in ipsum id orci porta dapibus. Quisque velit nisi, pretium ut lacinia in, elementum id enim.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"fa fa-rocket","title":"Pellentesque habitant","link_target":"0","content":"Pellentesque in ipsum id orci porta dapibus. Quisque velit nisi, pretium ut lacinia in, elementum id enim.","elname":"Box icon"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"boxesicon_item","icon":"fa fa-plug","title":"Etiam rhoncus","link_target":"0","content":"Pellentesque in ipsum id orci porta dapibus. Quisque velit nisi, pretium ut lacinia in, elementum id enim.","elname":"Box icon"},"attr":[]}]},{"type":"mb2pb_el","settings":{"id":"button","type":"primary","size":"xlg","link":"#","target":"0","fw":"0","fweight":"400","lspacing":"0","wspacing":"0","rounded":"0","upper":"0","ml":"0","mr":"0","mt":"10","mb":"30","border":"1","center":"1","text":"Nullam accumsan lorem","elname":"Button"},"attr":[]}]}]}]'
		)
	)
);

define( 'LOCAL_MB2BUILDER_IMPORT_BLOCKS_ICONBOXES', base64_encode( serialize( $mb2_settings ) ) );
