<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package    local_mb2builder
 * @copyright  2018 - 2020 Mariusz Boloz (mb2moodle.com/)
 * @license   Commercial https://themeforest.net/licenses
 */

defined( 'MOODLE_INTERNAL' ) || die();

$mb2_settings = array(
	'id' => 'footer',
	'title' => get_string( 'footer', 'local_mb2builder' ),
	'items' => array(
		array(
			'name' => 'footer-2',
			'thumb' => 'footer-2',
			'tags' => 'footer',
			'data' => '[{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(39, 50, 58)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"dark","bordert":"0","borderb":"0","bordertcolor":"#dddddd","borderbcolor":"#dddddd","heroimg":"0","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"60","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"3","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"image","align":"none","center":"0","width":"43","mt":"0","mb":"30","caption":"0","captiontext":"Caption text here","link_target":"0","text":"mb2sampledata:2023/01/logo_small","elname":"Image"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"listicon","style":"disc","icon":"fa fa-check-square-o","border":"0","borderw":"2","horizontal":"0","fwcls":"bold","iconbg":"0","mt":"0","mb":"30","elname":"List icon"},"attr":[{"type":"mb2pb_subel","settings":{"id":"listicon_item","icon":"fa fa-envelope","iconcolor":"rgb(144, 150, 153)","textcolor":"rgb(144, 150, 153)","link_target":"0","text":"info@example.com","elname":"List icon item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"listicon_item","icon":"fa fa-phone","iconcolor":"rgb(144, 150, 153)","textcolor":"rgb(144, 150, 153)","link_target":"0","text":"+12 345 67 89","elname":"List icon item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"listicon_item","icon":"fa fa-fax","iconcolor":"rgb(144, 150, 153)","textcolor":"rgb(144, 150, 153)","link_target":"0","text":"+12 345 67 89","elname":"List icon item"},"attr":[]}]}]},{"type":"mb2pb_col","settings":{"id":"column","col":"3","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h4","size":"1.2","align":"none","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"30","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Education","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"list","style":"none","horizontal":"0","align":"none","fwcls":"global","color":"rgb(144, 150, 153)","mt":"0","mb":"30","elname":"List"},"attr":[{"type":"mb2pb_subel","settings":{"id":"list_item","link":"#","text":"Pellentesque laoreet","elname":"List item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"list_item","link":"#","text":"Felis eros vehicula","elname":"List item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"list_item","link":"#","text":"Leo at males","elname":"List item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"list_item","link":"#","text":"Velit leo quis pede","elname":"List item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"list_item","link":"#","text":"Class aptent taciti","elname":"List item"},"attr":[]}]}]},{"type":"mb2pb_col","settings":{"id":"column","col":"3","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h4","size":"1.2","align":"none","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"30","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Useful Links","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"list","style":"none","horizontal":"0","align":"none","fwcls":"global","color":"rgb(144, 150, 153)","mt":"0","mb":"30","elname":"List"},"attr":[{"type":"mb2pb_subel","settings":{"id":"list_item","link":"#","text":"Nulla porttitor accumsan","elname":"List item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"list_item","link":"#","text":"Sed porttitor lectus nibh","elname":"List item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"list_item","link":"#","text":"Proin eget tortor risus","elname":"List item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"list_item","link":"#","text":"Donec sollicitudin molestie","elname":"List item"},"attr":[]}]}]},{"type":"mb2pb_col","settings":{"id":"column","col":"3","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h4","size":"1.2","align":"none","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"30","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"New Learning College","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"none","size":"n","sizerem":"1","color":"rgb(144, 150, 153)","showtitle":"0","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","upper":"0","title":"Title text","mt":"0","mb":"30","pv":"0","ph":"0","tmb":"30","width":"2000","rounded":"0","gradient":"0","button":"0","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"0","bborder":"0","btext":"Read more","bfwcls":"global","scheme":"light","content":"<p>Praesent sapien massa, convallis a pellentesque nec, egestas non nisi vivamus suscipit.</p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"button","type":"primary","size":"normal","link":"#","target":"0","fw":"0","fwcls":"medium","lspacing":"0","wspacing":"0","rounded":"0","upper":"0","ml":"0","mr":"0","mt":"0","mb":"15","border":"0","center":"0","text":"Read more","elname":"Button"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(33, 42, 49)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"dark","bordert":"0","borderb":"0","bordertcolor":"#dddddd","borderbcolor":"#dddddd","heroimg":"0","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"30","pb":"0","fw":"0","va":"1","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"1","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"date","textbefore":"© 2017 - ","textafter":" New Learning Theme. All rights reserved.","mt":"0","mb":"15","sizerem":"1","color":"rgb(144, 150, 153)","elname":"Date"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"languages","horizontal":"1","image":"0","mt":"0","mb":"0","sizerem":"1","color":"rgb(144, 150, 153)","elname":"Languages"},"attr":[]}]},{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"1","moborder":"0","align":"right","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"social","mt":"0","mb":"0","elname":"Social icons"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(33, 42, 49)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"dark","bordert":"1","borderb":"0","bordertcolor":"rgba(255, 255, 255, 0.1)","borderbcolor":"#dddddd","heroimg":"0","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"30","pb":"0","fw":"0","va":"1","parallax":"0","rowaccess":"1","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"1","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"footertools","mt":"0","mb":"0","sizerem":"1","color":"rgb(144, 150, 153)","elname":"Footer tools"},"attr":[]}]}]}]'
		),
		array(
			'name' => 'footer-3',
			'thumb' => 'footer-3',
			'tags' => 'footer',
			'data' => '[{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(247, 247, 247)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","bordert":"0","borderb":"0","bordertcolor":"#dddddd","borderbcolor":"#dddddd","heroimg":"0","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"60","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"3","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"image","align":"none","center":"0","width":"43","mt":"0","mb":"30","caption":"0","captiontext":"Caption text here","link_target":"0","text":"mb2sampledata:2023/01/logo_small","elname":"Image"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"listicon","style":"disc","icon":"fa fa-check-square-o","border":"0","borderw":"2","horizontal":"0","fwcls":"bold","iconbg":"0","mt":"0","mb":"30","elname":"List icon"},"attr":[{"type":"mb2pb_subel","settings":{"id":"listicon_item","icon":"fa fa-envelope","link_target":"0","text":"info@example.com","elname":"List icon item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"listicon_item","icon":"fa fa-phone","link_target":"0","text":"+12 345 67 89","elname":"List icon item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"listicon_item","icon":"fa fa-fax","link_target":"0","text":"+12 345 67 89","elname":"List icon item"},"attr":[]}]}]},{"type":"mb2pb_col","settings":{"id":"column","col":"3","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h4","size":"1.2","align":"none","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"30","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Education","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"list","style":"none","horizontal":"0","align":"none","fwcls":"global","mt":"0","mb":"30","elname":"List"},"attr":[{"type":"mb2pb_subel","settings":{"id":"list_item","link":"#","text":"Pellentesque laoreet","elname":"List item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"list_item","link":"#","text":"Felis eros vehicula","elname":"List item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"list_item","link":"#","text":"Leo at males","elname":"List item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"list_item","link":"#","text":"Velit leo quis pede","elname":"List item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"list_item","link":"#","text":"Class aptent taciti","elname":"List item"},"attr":[]}]}]},{"type":"mb2pb_col","settings":{"id":"column","col":"3","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h4","size":"1.2","align":"none","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"30","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"Useful Links","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"list","style":"none","horizontal":"0","align":"none","fwcls":"global","mt":"0","mb":"30","elname":"List"},"attr":[{"type":"mb2pb_subel","settings":{"id":"list_item","link":"#","text":"Nulla porttitor accumsan","elname":"List item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"list_item","link":"#","text":"Sed porttitor lectus nibh","elname":"List item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"list_item","link":"#","text":"Proin eget tortor risus","elname":"List item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"list_item","link":"#","text":"Donec sollicitudin molestie","elname":"List item"},"attr":[]}]}]},{"type":"mb2pb_col","settings":{"id":"column","col":"3","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h4","size":"1.2","align":"none","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","mt":"0","mb":"30","width":"2000","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","content":"New Learning College","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"text","align":"none","size":"n","sizerem":"1","showtitle":"0","fwcls":"global","lhcls":"global","lspacing":"0","wspacing":"0","tupper":"0","tfwcls":"global","tlhcls":"global","tlspacing":"0","twspacing":"0","tsizerem":"1.4","upper":"0","title":"Title text","mt":"0","mb":"30","pv":"0","ph":"0","tmb":"30","width":"2000","rounded":"0","gradient":"0","button":"0","btype":"primary","bsize":"normal","link":"#","target":"0","brounded":"0","bmt":"0","bborder":"0","btext":"Read more","bfwcls":"global","scheme":"light","content":"<p>Praesent sapien massa, convallis a pellentesque nec, egestas non nisi vivamus suscipit.</p>","elname":"Text"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"button","type":"primary","size":"normal","link":"#","target":"0","fw":"0","fwcls":"medium","lspacing":"0","wspacing":"0","rounded":"0","upper":"0","ml":"0","mr":"0","mt":"0","mb":"15","border":"0","center":"0","text":"Read more","elname":"Button"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(234, 234, 234)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","bordert":"0","borderb":"0","bordertcolor":"#dddddd","borderbcolor":"#dddddd","heroimg":"0","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"30","pb":"0","fw":"0","va":"1","parallax":"0","rowaccess":"0","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"1","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"date","textbefore":"© 2017 - ","textafter":" New Learning Theme. All rights reserved.","mt":"0","mb":"15","sizerem":"1","elname":"Date"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"languages","horizontal":"1","image":"0","mt":"0","mb":"0","sizerem":"1","elname":"Languages"},"attr":[]}]},{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"1","moborder":"0","align":"right","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"social","mt":"0","mb":"0","elname":"Social icons"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(234, 234, 234)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","bordert":"1","borderb":"0","bordertcolor":"rgba(0, 0, 0, 0.1)","borderbcolor":"#dddddd","heroimg":"0","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","rowhidden":"0","pt":"30","pb":"0","fw":"0","va":"1","parallax":"0","rowaccess":"1","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"1","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"footertools","mt":"0","mb":"0","sizerem":"1","elname":"Footer tools"},"attr":[]}]}]}]'
		),
		array(
			'name' => 'footer-4',
			'thumb' => 'footer-4',
			'tags' => 'footer',
			'data' => '[{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(242, 246, 250)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","bgimage":"","bordert":"0","borderb":"0","bordertcolor":"#dddddd","borderbcolor":"#dddddd","heroimg":"0","heroimgurl":"","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","bgvideo":"","rowhidden":"0","rowlang":"","pt":"90","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","custom_class":"","template":"","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"45","gradloc1":"0","gradloc2":"100","gradcolor1":"#37E2D5","gradcolor2":"#590696","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"0","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"image","align":"none","center":"1","width":"43","alt":"","mt":"0","mb":"30","caption":"0","captiontext":"Caption text here","link":"","link_target":"0","custom_class":"","template":"","text":"mb2sampledata:2022/12/logo_language_small","elname":"Image"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(242, 246, 250)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","bgimage":"","bordert":"0","borderb":"0","bordertcolor":"#dddddd","borderbcolor":"#dddddd","heroimg":"0","heroimgurl":"","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","bgvideo":"","rowhidden":"0","rowlang":"","pt":"60","pb":"0","fw":"0","va":"0","parallax":"0","rowaccess":"0","custom_class":"","template":"","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradloc1":"0","gradloc2":"100","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"3","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h4","size":"1","align":"none","btext":"","atext":"","fwcls":"bold","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","nline":"0","mt":"0","mb":"30","width":"2000","color":"","acolor":"","bcolor":"","afwcls":"global","bfwcls":"global","custom_class":"","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","template":"","content":"Education","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"list","style":"none","icon":"","horizontal":"0","align":"none","custom_class":"","fwcls":"global","color":"","mt":"0","mb":"30","template":"","elname":"List"},"attr":[{"type":"mb2pb_subel","settings":{"id":"list_item","icon":"","link":"#","link_target":"","template":"","text":"Pellentesque laoreet","elname":"List item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"list_item","icon":"","link":"#","link_target":"","template":"","text":"Felis eros vehicula","elname":"List item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"list_item","icon":"","link":"#","link_target":"","template":"","text":"Leo at males","elname":"List item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"list_item","icon":"","link":"#","link_target":"","template":"","text":"Velit leo quis pede","elname":"List item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"list_item","icon":"","link":"#","link_target":"","template":"","text":"Class aptent taciti","elname":"List item"},"attr":[]}]}]},{"type":"mb2pb_col","settings":{"id":"column","col":"3","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h4","size":"1","align":"none","btext":"","atext":"","fwcls":"bold","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","nline":"0","mt":"0","mb":"30","width":"2000","color":"","acolor":"","bcolor":"","afwcls":"global","bfwcls":"global","custom_class":"","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","template":"","content":"Useful Links","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"list","style":"none","icon":"","horizontal":"0","align":"none","custom_class":"","fwcls":"global","color":"","mt":"0","mb":"30","template":"","elname":"List"},"attr":[{"type":"mb2pb_subel","settings":{"id":"list_item","icon":"","link":"#","link_target":"","template":"","text":"Nulla porttitor accumsan","elname":"List item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"list_item","icon":"","link":"#","link_target":"","template":"","text":"Proin eget tortor risus","elname":"List item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"list_item","icon":"","link":"#","link_target":"","template":"","text":"Sed porttitor lectus nibh","elname":"List item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"list_item","icon":"","link":"#","link_target":"","template":"","text":"Donec sollicitudin molestie","elname":"List item"},"attr":[]}]}]},{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"0","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"heading","tag":"h4","size":"1","align":"none","btext":"","atext":"","fwcls":"bold","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","nline":"0","mt":"0","mb":"30","width":"2000","color":"","acolor":"","bcolor":"","afwcls":"global","bfwcls":"global","custom_class":"","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","template":"","content":"New Learning Language School is available on Android and iOS","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"html","el_onmobile":"1","text":"<img src=\"https://dummyimage.com/270x90/eeeeee/333.jpg\" style=\"width:135px;margin-right:1rem;\"><img src=\"https://dummyimage.com/304x90/eeeeee/333.jpg\" style=\"width:152px\">","template":"","elname":"HTML"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"heading","tag":"h4","size":"1","align":"none","btext":"","atext":"","fwcls":"bold","lhcls":"global","lspacing":"0","wspacing":"0","upper":"0","nline":"0","mt":"50","mb":"27","width":"2000","color":"","acolor":"","bcolor":"","afwcls":"global","bfwcls":"global","custom_class":"","typed":"0","typespeed":"50","backspeed":"50","backdelay":"1500","typedtext":"first word|second word|third word","template":"","content":"Connect with us:","elname":"Heading"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"social","type":"2","mt":"0","mb":"30","custom_class":"","template":"","elname":"Social icons"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(242, 246, 250)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","bgimage":"","bordert":"0","borderb":"0","bordertcolor":"","borderbcolor":"","heroimg":"0","heroimgurl":"","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","bgvideo":"","rowhidden":"0","rowlang":"","pt":"0","pb":"0","fw":"0","va":"1","parallax":"0","rowaccess":"0","custom_class":"","template":"","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradloc1":"0","gradloc2":"100","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"12","pt":"0","pb":"30","mobcenter":"1","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"line","color":"custom","custom_color":"rgba(0, 0, 0, 0.1)","size":"1","double":"0","style":"solid","mt":"0","mb":"30","custom_class":"","template":"","elname":"Line"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"listicon","style":"disc","icon":"fa fa-check-square-o","bgcolor":"","iconcolor":"rgb(58, 12, 163)","textcolor":"","border":"0","borderw":"2","bordercolor":"rgb(90, 172, 218)","horizontal":"1","align":"none","fwcls":"global","isize":"3.7","space":"1.7","iconbg":"0","fs":"1","custom_class":"","mt":"0","mb":"30","template":"","elname":"List icon"},"attr":[{"type":"mb2pb_subel","settings":{"id":"listicon_item","icon":"lni-envelope","bgcolor":"","iconcolor":"","textcolor":"","bordercolor":"","link":"","link_target":"0","template":"","text":"support@example.com","elname":"List icon item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"listicon_item","icon":"lni-phone-handset","bgcolor":"","iconcolor":"","textcolor":"","bordercolor":"","link":"","link_target":"0","template":"","text":"+12 345 67 89","elname":"List icon item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"listicon_item","icon":"lni-map-marker","bgcolor":"","iconcolor":"","textcolor":"","bordercolor":"","link":"","link_target":"0","template":"","text":"PO Box 16122 Collins Street West,  Victoria 8007 Australia","elname":"List icon item"},"attr":[]}]},{"type":"mb2pb_el","settings":{"id":"image","align":"none","center":"0","width":"295","alt":"","mt":"0","mb":"0","caption":"0","captiontext":"Caption text here","link":"","link_target":"0","custom_class":"","template":"","text":"https://dummyimage.com/593x65/eeeeee/333.jpg","elname":"Image"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"line","color":"custom","custom_color":"rgba(0, 0, 0, 0.1)","size":"1","double":"0","style":"solid","mt":"30","mb":"0","custom_class":"","template":"","elname":"Line"},"attr":[]}]}]},{"type":"mb2pb_row","settings":{"id":"row","bgcolor":"rgb(242, 246, 250)","bgfixed":"0","colgutter":"s","prbg":"0","scheme":"light","bgimage":"","bordert":"0","borderb":"0","bordertcolor":"","borderbcolor":"#dddddd","heroimg":"0","heroimgurl":"","herov":"center","herow":"1200","herohpos":"left","heroml":"0","heromt":"0","heroonsmall":"1","herogradl":"0","herogradr":"0","bgtext":"0","bgtextmob":"0","bgtexttext":"Sample text","btsize":"290","btfweight":"600","btlh":"1","btlspacing":"0","btwspacing":"0","btupper":"0","bth":"left","btv":"center","btcolor":"rgba(0,0,0,.05)","bgvideo":"","rowhidden":"0","rowlang":"","pt":"30","pb":"0","fw":"0","va":"1","parallax":"0","rowaccess":"0","custom_class":"","template":"","wave":"none","wavecolor":"#ffffff","wavepos":"0","wavefliph":"0","wavetop":"0","wavewidth":"100","waveheight":"150","waveover":"1","mt":"0","gradient":"0","graddeg":"90","gradloc1":"0","gradloc2":"100","gradcolor1":"#3A0CA3","gradcolor2":"#4361EE","elname":"Row"},"attr":[{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"1","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"date","textbefore":"© 2017 - ","textafter":" New Learning Theme. All rights reserved.","mt":"0","mb":"15","sizerem":"1","color":"","custom_class":"","template":"","elname":"Date"},"attr":[]},{"type":"mb2pb_el","settings":{"id":"languages","horizontal":"1","image":"0","mt":"0","mb":"0","sizerem":"1","color":"","custom_class":"","template":"","elname":"Languages"},"attr":[]}]},{"type":"mb2pb_col","settings":{"id":"column","col":"6","pt":"0","pb":"30","mobcenter":"1","moborder":"0","align":"none","alignc":"none","height":"0","width":"2000","scheme":"light","bgcolor":"","bgimage":"","custom_class":"","elname":"Column"},"attr":[{"type":"mb2pb_el","settings":{"id":"list","style":"none","icon":"","horizontal":"1","align":"right","custom_class":"","fwcls":"bold","color":"rgb(36, 32, 39)","mt":"0","mb":"30","template":"","elname":"List"},"attr":[{"type":"mb2pb_subel","settings":{"id":"list_item","icon":"","link":"#","link_target":"","template":"","text":"About","elname":"List item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"list_item","icon":"","link":"#","link_target":"","template":"","text":"Courses","elname":"List item"},"attr":[]},{"type":"mb2pb_subel","settings":{"id":"list_item","icon":"","link":"#","link_target":"","template":"","text":"Support","elname":"List item"},"attr":[]}]}]}]}]'
		)
	)
);

define( 'LOCAL_MB2BUILDER_IMPORT_BLOCKS_FOOTER', base64_encode( serialize( $mb2_settings ) ) );
