/**
 * Javascript controller for the "Grading" panel at the right of the page.
 *
 * @module     mod_assign/grading_panel
 * @package    mod_assign
 * @class      GradingPanel
 * @copyright  2016 Damyon Wiese <damyon@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      3.1
 */
define(["jquery","core/ajax","core/event","core/notification"],function(s,r,e,i){function t(e){this._regionSelector=e,this._region=s(e),this._coursesArea=s(e).find(".courses-container-inner"),this._userCache=[],this.registerEventListeners()}return t.prototype._submitForm=function(e){e.preventDefault();e=s(this._region.find(".theme-course-filter"));e.trigger("save-form-state");e=e.serialize();s(this._coursesArea).addClass("loading"),s("html, body").stop().animate({scrollTop:s(this._coursesArea).offset().top-165},650),r.call([{methodname:"theme_mb2nl_subscribe",args:{formdata:e},done:this._handleResponse.bind(this),fail:i.exception}])},t.prototype._pagination=function(e){e.preventDefault();var t=s(this._region.find(".theme-courses-list")),e=s(e.currentTarget);if(t.data("page")==e.data("page"))return null;s(this._coursesArea).addClass("loading"),s("html, body").stop().animate({scrollTop:s(this._coursesArea).offset().top-165},650),r.call([{methodname:"theme_mb2nl_course_pagination",args:{page:e.data("page"),categories:t.data("categories"),tags:t.data("tags"),instructors:t.data("instructors"),price:t.data("price"),searchstr:t.data("searchstr")},done:this._handleResponse.bind(this),fail:i.exception}])},t.prototype._submitSearchForm=function(e){e.preventDefault();var t=s(this._region.find(".theme-courses-list")),e=s(this._region.find("#theme-course-search"));s(this._region.find(".theme-course-search")).trigger("save-form-state");e=e.val().replace(/<\/?[^>]+(>|$)/g,"").toLowerCase();s("html, body").stop().animate({scrollTop:s(this._coursesArea).offset().top-165},650),s(this._coursesArea).addClass("loading"),r.call([{methodname:"theme_mb2nl_course_search",args:{searchstr:e,categories:t.data("categories"),tags:t.data("tags"),instructors:t.data("instructors"),price:t.data("price")},done:this._handleResponse.bind(this),fail:i.exception}])},t.prototype._handleResponse=function(e){setTimeout(function(){s(this._coursesArea).empty(),s(this._coursesArea).append(e.courses),s(this._coursesArea).removeClass("loading")}.bind(this),2e3)},t.prototype.registerEventListeners=function(){s(document);var e=s(this._region);e.on("click",".theme-courses-paginitem",this._pagination.bind(this)),e.on("submit",".theme-course-filter",this._submitForm.bind(this)),e.on("submit",".theme-course-search",this._submitSearchForm.bind(this))},t});
