<?php
class block_buy_enrol_now extends block_base {
    public function init() {
        $this->title = get_string('pluginname', 'block_buy_enrol_now');
    }

    public function instance_allow_config() {
        return true;
    }

    public function specialization() {
        if (isset($this->config)) {
            if (empty($this->config->title)) {
                $this->title = get_string('pluginname', 'block_buy_enrol_now');
            } else {
                $this->title = $this->config->title;
            }
        }
    }

    public function get_content() {
        global $COURSE, $USER, $OUTPUT, $PAGE;

        if ($this->content !== null) {
            return $this->content;
        }
        $this->content = new stdClass();

        // Add Tabler Icons CSS from CDN
        $PAGE->requires->css(new moodle_url('https://cdn.jsdelivr.net/npm/@tabler/icons-webfont@latest/tabler-icons.min.css'));

        // Get course context
        $context = context_course::instance($COURSE->id);

        // Check if user is a teacher or has course update capability
        $userteaching = has_capability('moodle/course:update', $context, $USER);

        // Check if user is enrolled
        $enrolled = is_enrolled($context, $USER, '', true);

        // Get price and currency from instance config
        $price = isset($this->config->price) ? $this->config->price : '$49.99';
        $currency = isset($this->config->currency) ? $this->config->currency : 'USD';
        $buttonurl = isset($this->config->button_url) ? $this->config->button_url : '/contact';
        $featurecount = isset($this->config->feature_count) ? $this->config->feature_count : 6;

        // Build features list
        $features = array();
        
        // Get all configured features up to the selected count
        for ($i = 1; $i <= $featurecount; $i++) {
            $icon = isset($this->config->{'icon_' . $i}) ? $this->config->{'icon_' . $i} : '';
            $text = isset($this->config->{'feature_' . $i}) ? $this->config->{'feature_' . $i} : '';
            
            if (!empty($text)) {
                $features[] = array(
                    'icon' => $icon,
                    'text' => $text
                );
            }
        }

        // Output depending on role / enrolment
        if ($userteaching) {
            $this->content->text = '<div class="alert alert-info"><strong>You\'re teaching</strong><br>You are currently teaching this course.</div>';
        } else if ($enrolled) {
            $this->content->text = '<div class="alert alert-success">✅ You\'re enrolled in this course.</div>';
        } else {
            // Guest OR logged-in user who is not enrolled
            $contacturl = new moodle_url($buttonurl);
            $this->content->text = '
            <div class="price">
                <i class="ti ti-credit-card"></i><span>Price</span> <strong>' . $price . '</strong> <small>' . $currency . '</small>
            </div>
            <a href="' . $contacturl->out(false) . '" class="btn btn-primary btn-block">Buy &amp; Enrol Now</a>
            <div class="ccn-buy-access">Unlimited Course Access</div>
            <ul class="price_quere_list text-left">';
            
            foreach ($features as $feature) {
                $this->content->text .= '
                    <li>
                        <div class="ccn-course-details-item">
                            <span class="' . $feature['icon'] . '"></span> ' . $feature['text'] . '
                        </div>
                    </li>';
            }
            
            $this->content->text .= '
            </ul>';
        }

        $this->content->footer = '';
        return $this->content;
    }

    public function has_config() {
        return false;
    }
} 