<?php
defined('MOODLE_INTERNAL') || die();

require_once($CFG->dirroot.'/blocks/buy_enrol_now/block_buy_enrol_now.php');

class block_buy_enrol_now_edit_form extends block_edit_form {
    protected function specific_definition($mform) {
        // Section header title according to language file.
        $mform->addElement('header', 'config_header', get_string('blocksettings', 'block'));

        // Price configuration
        $mform->addElement('text', 'config_price', get_string('price', 'block_buy_enrol_now'));
        $mform->setType('config_price', PARAM_TEXT);
        $mform->setDefault('config_price', '$49.99');
        $mform->addHelpButton('config_price', 'price', 'block_buy_enrol_now');

        // Currency configuration
        $mform->addElement('text', 'config_currency', get_string('currency', 'block_buy_enrol_now'));
        $mform->setType('config_currency', PARAM_TEXT);
        $mform->setDefault('config_currency', 'USD');
        $mform->addHelpButton('config_currency', 'currency', 'block_buy_enrol_now');

        // Button URL configuration
        $mform->addElement('text', 'config_button_url', get_string('button_url', 'block_buy_enrol_now'));
        $mform->setType('config_button_url', PARAM_URL);
        $mform->setDefault('config_button_url', '/contact');
        $mform->addHelpButton('config_button_url', 'button_url', 'block_buy_enrol_now');

        // Feature count configuration
        $mform->addElement('select', 'config_feature_count', get_string('feature_count', 'block_buy_enrol_now'), 
            array(1 => '1', 2 => '2', 3 => '3', 4 => '4', 5 => '5', 6 => '6', 7 => '7', 8 => '8', 9 => '9', 10 => '10'));
        $mform->setDefault('config_feature_count', 6);
        $mform->addHelpButton('config_feature_count', 'feature_count', 'block_buy_enrol_now');

        // Course features section
        $mform->addElement('header', 'config_features', get_string('features', 'block_buy_enrol_now'));

        // Icon options for features (Tabler Icons)
        $iconoptions = array(
            'ti ti-play' => 'Play',
            'ti ti-video' => 'Video',
            'ti ti-file' => 'File',
            'ti ti-clock' => 'Clock',
            'ti ti-calendar' => 'Calendar',
            'ti ti-user' => 'User',
            'ti ti-download' => 'Download',
            'ti ti-book' => 'Book',
            'ti ti-certificate' => 'Certificate',
            'ti ti-message' => 'Message',
            'ti ti-chat' => 'Chat',
            'ti ti-mail' => 'Mail',
            'ti ti-phone' => 'Phone',
            'ti ti-map-pin' => 'Location',
            'ti ti-link' => 'Link',
            'ti ti-share' => 'Share',
            'ti ti-heart' => 'Heart',
            'ti ti-star' => 'Star',
            'ti ti-check' => 'Check',
            'ti ti-plus' => 'Plus',
            'ti ti-minus' => 'Minus',
            'ti ti-x' => 'Close',
            'ti ti-menu' => 'Menu',
            'ti ti-search' => 'Search',
            'ti ti-settings' => 'Settings',
            'ti ti-refresh' => 'Refresh',
            'ti ti-upload' => 'Upload',
            'ti ti-file-text' => 'Document',
            'ti ti-folder' => 'Folder',
            'ti ti-photo' => 'Image',
            'ti ti-music' => 'Music'
        );

        // Add feature fields
        for ($i = 1; $i <= 10; $i++) {
            $mform->addElement('select', 'config_icon_' . $i, get_string('feature_icon', 'block_buy_enrol_now') . ' ' . $i, $iconoptions);
            $mform->setDefault('config_icon_' . $i, 'ti ti-play');
            
            $mform->addElement('text', 'config_feature_' . $i, get_string('feature_text', 'block_buy_enrol_now') . ' ' . $i);
            $mform->setType('config_feature_' . $i, PARAM_TEXT);
        }
    }
} 